# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2022_01_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2022_01_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Condition(_serialization.Model):
    """Governance rule's condition.

    :ivar property: The governance rule Condition's Property, e.g. Severity or AssessmentKey, see
     examples.
    :vartype property: str
    :ivar value: The governance rule Condition's Value like severity Low, High or assessments keys,
     see examples.
    :vartype value: str
    :ivar operator: The governance rule Condition's Operator, for example Equals for severity or In
     for list of assessments, see examples. Known values are: "Equals" and "In".
    :vartype operator: str or
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleConditionOperator
    """

    _attribute_map = {
        "property": {"key": "property", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self,
        *,
        property: Optional[str] = None,  # pylint: disable=redefined-builtin
        value: Optional[str] = None,
        operator: Optional[Union[str, "_models.GovernanceRuleConditionOperator"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword property: The governance rule Condition's Property, e.g. Severity or AssessmentKey,
         see examples.
        :paramtype property: str
        :keyword value: The governance rule Condition's Value like severity Low, High or assessments
         keys, see examples.
        :paramtype value: str
        :keyword operator: The governance rule Condition's Operator, for example Equals for severity or
         In for list of assessments, see examples. Known values are: "Equals" and "In".
        :paramtype operator: str or
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleConditionOperator
        """
        super().__init__(**kwargs)
        self.property = property
        self.value = value
        self.operator = operator


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ExecuteGovernanceRuleParams(_serialization.Model):
    """Governance rule execution parameters.

    :ivar override: Describe if governance rule should be override.
    :vartype override: bool
    """

    _attribute_map = {
        "override": {"key": "override", "type": "bool"},
    }

    def __init__(self, *, override: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword override: Describe if governance rule should be override.
        :paramtype override: bool
        """
        super().__init__(**kwargs)
        self.override = override


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class GovernanceAssignment(Resource):
    """Governance assignment over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar owner: The Owner for the governance assignment - e.g. user@contoso.com - see example.
    :vartype owner: str
    :ivar remediation_due_date: The remediation due-date - after this date Secure Score will be
     affected (in case of  active grace-period).
    :vartype remediation_due_date: ~datetime.datetime
    :ivar remediation_eta: The ETA (estimated time of arrival) for remediation (optional), see
     example.
    :vartype remediation_eta: ~azure.mgmt.security.v2022_01_01_preview.models.RemediationEta
    :ivar is_grace_period: Defines whether there is a grace period on the governance assignment.
    :vartype is_grace_period: bool
    :ivar governance_email_notification: The email notifications settings for the governance rule,
     states whether to disable notifications for mangers and owners.
    :vartype governance_email_notification:
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceEmailNotification
    :ivar additional_data: The additional data for the governance assignment - e.g. links to ticket
     (optional), see example.
    :vartype additional_data:
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceAssignmentAdditionalData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "owner": {"key": "properties.owner", "type": "str"},
        "remediation_due_date": {"key": "properties.remediationDueDate", "type": "iso-8601"},
        "remediation_eta": {"key": "properties.remediationEta", "type": "RemediationEta"},
        "is_grace_period": {"key": "properties.isGracePeriod", "type": "bool"},
        "governance_email_notification": {
            "key": "properties.governanceEmailNotification",
            "type": "GovernanceEmailNotification",
        },
        "additional_data": {"key": "properties.additionalData", "type": "GovernanceAssignmentAdditionalData"},
    }

    def __init__(
        self,
        *,
        owner: Optional[str] = None,
        remediation_due_date: Optional[datetime.datetime] = None,
        remediation_eta: Optional["_models.RemediationEta"] = None,
        is_grace_period: Optional[bool] = None,
        governance_email_notification: Optional["_models.GovernanceEmailNotification"] = None,
        additional_data: Optional["_models.GovernanceAssignmentAdditionalData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword owner: The Owner for the governance assignment - e.g. user@contoso.com - see example.
        :paramtype owner: str
        :keyword remediation_due_date: The remediation due-date - after this date Secure Score will be
         affected (in case of  active grace-period).
        :paramtype remediation_due_date: ~datetime.datetime
        :keyword remediation_eta: The ETA (estimated time of arrival) for remediation (optional), see
         example.
        :paramtype remediation_eta: ~azure.mgmt.security.v2022_01_01_preview.models.RemediationEta
        :keyword is_grace_period: Defines whether there is a grace period on the governance assignment.
        :paramtype is_grace_period: bool
        :keyword governance_email_notification: The email notifications settings for the governance
         rule, states whether to disable notifications for mangers and owners.
        :paramtype governance_email_notification:
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceEmailNotification
        :keyword additional_data: The additional data for the governance assignment - e.g. links to
         ticket (optional), see example.
        :paramtype additional_data:
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceAssignmentAdditionalData
        """
        super().__init__(**kwargs)
        self.owner = owner
        self.remediation_due_date = remediation_due_date
        self.remediation_eta = remediation_eta
        self.is_grace_period = is_grace_period
        self.governance_email_notification = governance_email_notification
        self.additional_data = additional_data


class GovernanceAssignmentAdditionalData(_serialization.Model):
    """Describe the additional data of governance assignment - optional.

    :ivar ticket_number: Ticket number associated with this governance assignment.
    :vartype ticket_number: int
    :ivar ticket_link: Ticket link associated with this governance assignment - for example:
     https://snow.com.
    :vartype ticket_link: str
    :ivar ticket_status: The ticket status associated with this governance assignment - for
     example: Active.
    :vartype ticket_status: str
    """

    _validation = {
        "ticket_number": {"minimum": 0},
    }

    _attribute_map = {
        "ticket_number": {"key": "ticketNumber", "type": "int"},
        "ticket_link": {"key": "ticketLink", "type": "str"},
        "ticket_status": {"key": "ticketStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        ticket_number: Optional[int] = None,
        ticket_link: Optional[str] = None,
        ticket_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ticket_number: Ticket number associated with this governance assignment.
        :paramtype ticket_number: int
        :keyword ticket_link: Ticket link associated with this governance assignment - for example:
         https://snow.com.
        :paramtype ticket_link: str
        :keyword ticket_status: The ticket status associated with this governance assignment - for
         example: Active.
        :paramtype ticket_status: str
        """
        super().__init__(**kwargs)
        self.ticket_number = ticket_number
        self.ticket_link = ticket_link
        self.ticket_status = ticket_status


class GovernanceAssignmentsList(_serialization.Model):
    """Page of a governance assignments list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of governance assignments in this page.
    :vartype value: list[~azure.mgmt.security.v2022_01_01_preview.models.GovernanceAssignment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GovernanceAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class GovernanceEmailNotification(_serialization.Model):
    """The governance email weekly notification configuration.

    :ivar disable_manager_email_notification: Exclude manager from weekly email notification.
    :vartype disable_manager_email_notification: bool
    :ivar disable_owner_email_notification: Exclude  owner from weekly email notification.
    :vartype disable_owner_email_notification: bool
    """

    _attribute_map = {
        "disable_manager_email_notification": {"key": "disableManagerEmailNotification", "type": "bool"},
        "disable_owner_email_notification": {"key": "disableOwnerEmailNotification", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_manager_email_notification: Optional[bool] = None,
        disable_owner_email_notification: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_manager_email_notification: Exclude manager from weekly email notification.
        :paramtype disable_manager_email_notification: bool
        :keyword disable_owner_email_notification: Exclude  owner from weekly email notification.
        :paramtype disable_owner_email_notification: bool
        """
        super().__init__(**kwargs)
        self.disable_manager_email_notification = disable_manager_email_notification
        self.disable_owner_email_notification = disable_owner_email_notification


class GovernanceRule(Resource):  # pylint: disable=too-many-instance-attributes
    """Governance rule over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tenant_id: The tenantId (GUID).
    :vartype tenant_id: str
    :ivar display_name: Display name of the governance rule.
    :vartype display_name: str
    :ivar description: Description of the governance rule.
    :vartype description: str
    :ivar remediation_timeframe: Governance rule remediation timeframe - this is the time that will
     affect on the grace-period duration e.g. 7.00:00:00 - means 7 days.
    :vartype remediation_timeframe: str
    :ivar is_grace_period: Defines whether there is a grace period on the governance rule.
    :vartype is_grace_period: bool
    :ivar rule_priority: The governance rule priority, priority to the lower number. Rules with the
     same priority on the same scope will not be allowed.
    :vartype rule_priority: int
    :ivar is_disabled: Defines whether the rule is active/inactive.
    :vartype is_disabled: bool
    :ivar rule_type: The rule type of the governance rule, defines the source of the rule e.g.
     Integrated. Known values are: "Integrated" and "ServiceNow".
    :vartype rule_type: str or ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleType
    :ivar source_resource_type: The governance rule source, what the rule affects, e.g.
     Assessments. "Assessments"
    :vartype source_resource_type: str or
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleSourceResourceType
    :ivar excluded_scopes: Excluded scopes, filter out the descendants of the scope (on management
     scopes).
    :vartype excluded_scopes: list[str]
    :ivar condition_sets: The governance rule conditionSets - see examples.
    :vartype condition_sets: list[JSON]
    :ivar include_member_scopes: Defines whether the rule is management scope rule (master
     connector as a single scope or management scope).
    :vartype include_member_scopes: bool
    :ivar owner_source: The owner source for the governance rule - e.g. Manually by
     user@contoso.com - see example.
    :vartype owner_source:
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleOwnerSource
    :ivar governance_email_notification: The email notifications settings for the governance rule,
     states whether to disable notifications for mangers and owners.
    :vartype governance_email_notification:
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleEmailNotification
    :ivar metadata: The governance rule metadata.
    :vartype metadata: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleMetadata
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "tenant_id": {"readonly": True},
        "remediation_timeframe": {"pattern": r"^[0-9]+\.[0-9]{2}:[0-9]{2}:[0-9]{2}$"},
        "rule_priority": {"maximum": 1000, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_timeframe": {"key": "properties.remediationTimeframe", "type": "str"},
        "is_grace_period": {"key": "properties.isGracePeriod", "type": "bool"},
        "rule_priority": {"key": "properties.rulePriority", "type": "int"},
        "is_disabled": {"key": "properties.isDisabled", "type": "bool"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "source_resource_type": {"key": "properties.sourceResourceType", "type": "str"},
        "excluded_scopes": {"key": "properties.excludedScopes", "type": "[str]"},
        "condition_sets": {"key": "properties.conditionSets", "type": "[object]"},
        "include_member_scopes": {"key": "properties.includeMemberScopes", "type": "bool"},
        "owner_source": {"key": "properties.ownerSource", "type": "GovernanceRuleOwnerSource"},
        "governance_email_notification": {
            "key": "properties.governanceEmailNotification",
            "type": "GovernanceRuleEmailNotification",
        },
        "metadata": {"key": "properties.metadata", "type": "GovernanceRuleMetadata"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_timeframe: Optional[str] = None,
        is_grace_period: Optional[bool] = None,
        rule_priority: Optional[int] = None,
        is_disabled: Optional[bool] = None,
        rule_type: Optional[Union[str, "_models.GovernanceRuleType"]] = None,
        source_resource_type: Optional[Union[str, "_models.GovernanceRuleSourceResourceType"]] = None,
        excluded_scopes: Optional[List[str]] = None,
        condition_sets: Optional[List[JSON]] = None,
        include_member_scopes: Optional[bool] = None,
        owner_source: Optional["_models.GovernanceRuleOwnerSource"] = None,
        governance_email_notification: Optional["_models.GovernanceRuleEmailNotification"] = None,
        metadata: Optional["_models.GovernanceRuleMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the governance rule.
        :paramtype display_name: str
        :keyword description: Description of the governance rule.
        :paramtype description: str
        :keyword remediation_timeframe: Governance rule remediation timeframe - this is the time that
         will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days.
        :paramtype remediation_timeframe: str
        :keyword is_grace_period: Defines whether there is a grace period on the governance rule.
        :paramtype is_grace_period: bool
        :keyword rule_priority: The governance rule priority, priority to the lower number. Rules with
         the same priority on the same scope will not be allowed.
        :paramtype rule_priority: int
        :keyword is_disabled: Defines whether the rule is active/inactive.
        :paramtype is_disabled: bool
        :keyword rule_type: The rule type of the governance rule, defines the source of the rule e.g.
         Integrated. Known values are: "Integrated" and "ServiceNow".
        :paramtype rule_type: str or ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleType
        :keyword source_resource_type: The governance rule source, what the rule affects, e.g.
         Assessments. "Assessments"
        :paramtype source_resource_type: str or
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleSourceResourceType
        :keyword excluded_scopes: Excluded scopes, filter out the descendants of the scope (on
         management scopes).
        :paramtype excluded_scopes: list[str]
        :keyword condition_sets: The governance rule conditionSets - see examples.
        :paramtype condition_sets: list[JSON]
        :keyword include_member_scopes: Defines whether the rule is management scope rule (master
         connector as a single scope or management scope).
        :paramtype include_member_scopes: bool
        :keyword owner_source: The owner source for the governance rule - e.g. Manually by
         user@contoso.com - see example.
        :paramtype owner_source:
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleOwnerSource
        :keyword governance_email_notification: The email notifications settings for the governance
         rule, states whether to disable notifications for mangers and owners.
        :paramtype governance_email_notification:
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleEmailNotification
        :keyword metadata: The governance rule metadata.
        :paramtype metadata: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleMetadata
        """
        super().__init__(**kwargs)
        self.tenant_id = None
        self.display_name = display_name
        self.description = description
        self.remediation_timeframe = remediation_timeframe
        self.is_grace_period = is_grace_period
        self.rule_priority = rule_priority
        self.is_disabled = is_disabled
        self.rule_type = rule_type
        self.source_resource_type = source_resource_type
        self.excluded_scopes = excluded_scopes
        self.condition_sets = condition_sets
        self.include_member_scopes = include_member_scopes
        self.owner_source = owner_source
        self.governance_email_notification = governance_email_notification
        self.metadata = metadata


class GovernanceRuleEmailNotification(_serialization.Model):
    """The governance email weekly notification configuration.

    :ivar disable_manager_email_notification: Defines whether manager email notifications are
     disabled.
    :vartype disable_manager_email_notification: bool
    :ivar disable_owner_email_notification: Defines whether owner email notifications are disabled.
    :vartype disable_owner_email_notification: bool
    """

    _attribute_map = {
        "disable_manager_email_notification": {"key": "disableManagerEmailNotification", "type": "bool"},
        "disable_owner_email_notification": {"key": "disableOwnerEmailNotification", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_manager_email_notification: Optional[bool] = None,
        disable_owner_email_notification: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_manager_email_notification: Defines whether manager email notifications are
         disabled.
        :paramtype disable_manager_email_notification: bool
        :keyword disable_owner_email_notification: Defines whether owner email notifications are
         disabled.
        :paramtype disable_owner_email_notification: bool
        """
        super().__init__(**kwargs)
        self.disable_manager_email_notification = disable_manager_email_notification
        self.disable_owner_email_notification = disable_owner_email_notification


class GovernanceRuleList(_serialization.Model):
    """Page of a governance rules list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of governance rules in this page.
    :vartype value: list[~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GovernanceRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class GovernanceRuleMetadata(_serialization.Model):
    """The governance rule metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: Governance rule Created by object id (GUID).
    :vartype created_by: str
    :ivar created_on: Governance rule creation date.
    :vartype created_on: ~datetime.datetime
    :ivar updated_by: Governance rule last updated by object id (GUID).
    :vartype updated_by: str
    :ivar updated_on: Governance rule last update date.
    :vartype updated_on: ~datetime.datetime
    """

    _validation = {
        "created_by": {"readonly": True},
        "created_on": {"readonly": True},
        "updated_by": {"readonly": True},
        "updated_on": {"readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "updated_by": {"key": "updatedBy", "type": "str"},
        "updated_on": {"key": "updatedOn", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_by = None
        self.created_on = None
        self.updated_by = None
        self.updated_on = None


class GovernanceRuleOwnerSource(_serialization.Model):
    """Describe the owner source of governance rule.

    :ivar type: The owner type for the governance rule owner source. Known values are: "ByTag" and
     "Manually".
    :vartype type: str or
     ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleOwnerSourceType
    :ivar value: The source value e.g. tag key like owner name or email address.
    :vartype value: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.GovernanceRuleOwnerSourceType"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The owner type for the governance rule owner source. Known values are: "ByTag"
         and "Manually".
        :paramtype type: str or
         ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRuleOwnerSourceType
        :keyword value: The source value e.g. tag key like owner name or email address.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value


class OperationResultAutoGenerated(_serialization.Model):
    """Long run operation status of governance rule over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the long run operation result of governance rule. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.mgmt.security.v2022_01_01_preview.models.OperationResult
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None


class RemediationEta(_serialization.Model):
    """The ETA (estimated time of arrival) for remediation.

    All required parameters must be populated in order to send to Azure.

    :ivar eta: ETA for remediation. Required.
    :vartype eta: ~datetime.datetime
    :ivar justification: Justification for change of Eta. Required.
    :vartype justification: str
    """

    _validation = {
        "eta": {"required": True},
        "justification": {"required": True},
    }

    _attribute_map = {
        "eta": {"key": "eta", "type": "iso-8601"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(self, *, eta: datetime.datetime, justification: str, **kwargs: Any) -> None:
        """
        :keyword eta: ETA for remediation. Required.
        :paramtype eta: ~datetime.datetime
        :keyword justification: Justification for change of Eta. Required.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.eta = eta
        self.justification = justification
