from typing import TYPE_CHECKING

from gradio_client.client import Job

from gentopia.tools.gradio_tools.tools.gradio_tool import GradioTool

if TYPE_CHECKING:
    import gradio as gr


class TextToVideoTool(GradioTool):
    def __init__(
        self,
        name="TextToVideo",
        description=(
            "A tool for creating videos from text."
            "Use this tool to create videos from text prompts. "
            "Input will be a text prompt describing a video scene. "
            "The output will be a path to a video file."
        ),
        src="damo-vilab/modelscope-text-to-video-synthesis",
        hf_token=None,
        duplicate=False,
    ) -> None:
        super().__init__(name, description, src, hf_token, duplicate)

    def create_job(self, query: str) -> Job:
        return self.client.submit(query, -1, 16, 25, fn_index=1)

    def postprocess(self, output: str) -> str:
        return output

    def _block_output(self, gr) -> "gr.components.Component":
        return gr.Video()
