# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagementAgentDataSourceResult',
    'AwaitableGetManagementAgentDataSourceResult',
    'get_management_agent_data_source',
    'get_management_agent_data_source_output',
]

@pulumi.output_type
class GetManagementAgentDataSourceResult:
    """
    A collection of values returned by getManagementAgentDataSource.
    """
    def __init__(__self__, allow_metrics=None, compartment_id=None, connection_timeout=None, data_source_key=None, id=None, is_daemon_set=None, management_agent_id=None, metric_dimensions=None, name=None, namespace=None, proxy_url=None, read_data_limit=None, read_data_limit_in_kilobytes=None, read_timeout=None, resource_group=None, schedule_mins=None, state=None, time_created=None, time_updated=None, type=None, url=None):
        if allow_metrics and not isinstance(allow_metrics, str):
            raise TypeError("Expected argument 'allow_metrics' to be a str")
        pulumi.set(__self__, "allow_metrics", allow_metrics)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_timeout and not isinstance(connection_timeout, int):
            raise TypeError("Expected argument 'connection_timeout' to be a int")
        pulumi.set(__self__, "connection_timeout", connection_timeout)
        if data_source_key and not isinstance(data_source_key, str):
            raise TypeError("Expected argument 'data_source_key' to be a str")
        pulumi.set(__self__, "data_source_key", data_source_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_daemon_set and not isinstance(is_daemon_set, bool):
            raise TypeError("Expected argument 'is_daemon_set' to be a bool")
        pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if metric_dimensions and not isinstance(metric_dimensions, list):
            raise TypeError("Expected argument 'metric_dimensions' to be a list")
        pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if proxy_url and not isinstance(proxy_url, str):
            raise TypeError("Expected argument 'proxy_url' to be a str")
        pulumi.set(__self__, "proxy_url", proxy_url)
        if read_data_limit and not isinstance(read_data_limit, int):
            raise TypeError("Expected argument 'read_data_limit' to be a int")
        pulumi.set(__self__, "read_data_limit", read_data_limit)
        if read_data_limit_in_kilobytes and not isinstance(read_data_limit_in_kilobytes, int):
            raise TypeError("Expected argument 'read_data_limit_in_kilobytes' to be a int")
        pulumi.set(__self__, "read_data_limit_in_kilobytes", read_data_limit_in_kilobytes)
        if read_timeout and not isinstance(read_timeout, int):
            raise TypeError("Expected argument 'read_timeout' to be a int")
        pulumi.set(__self__, "read_timeout", read_timeout)
        if resource_group and not isinstance(resource_group, str):
            raise TypeError("Expected argument 'resource_group' to be a str")
        pulumi.set(__self__, "resource_group", resource_group)
        if schedule_mins and not isinstance(schedule_mins, int):
            raise TypeError("Expected argument 'schedule_mins' to be a int")
        pulumi.set(__self__, "schedule_mins", schedule_mins)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> str:
        """
        Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> int:
        """
        Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="dataSourceKey")
    def data_source_key(self) -> str:
        return pulumi.get(self, "data_source_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> bool:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> str:
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Sequence['outputs.GetManagementAgentDataSourceMetricDimensionResult']:
        """
        The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name of the DataSource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> str:
        """
        The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> int:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @property
    @pulumi.getter(name="readDataLimitInKilobytes")
    def read_data_limit_in_kilobytes(self) -> int:
        return pulumi.get(self, "read_data_limit_in_kilobytes")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> int:
        """
        Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> int:
        """
        Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the DataSource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the DataSource was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the DataSource data was last received. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DataSource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The url through which the Prometheus Exporter publishes its metrics. (http only)
        """
        return pulumi.get(self, "url")


class AwaitableGetManagementAgentDataSourceResult(GetManagementAgentDataSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentDataSourceResult(
            allow_metrics=self.allow_metrics,
            compartment_id=self.compartment_id,
            connection_timeout=self.connection_timeout,
            data_source_key=self.data_source_key,
            id=self.id,
            is_daemon_set=self.is_daemon_set,
            management_agent_id=self.management_agent_id,
            metric_dimensions=self.metric_dimensions,
            name=self.name,
            namespace=self.namespace,
            proxy_url=self.proxy_url,
            read_data_limit=self.read_data_limit,
            read_data_limit_in_kilobytes=self.read_data_limit_in_kilobytes,
            read_timeout=self.read_timeout,
            resource_group=self.resource_group,
            schedule_mins=self.schedule_mins,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            url=self.url)


def get_management_agent_data_source(data_source_key: Optional[str] = None,
                                     management_agent_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentDataSourceResult:
    """
    This data source provides details about a specific Management Agent Data Source resource in Oracle Cloud Infrastructure Management Agent service.

    Get Datasource details for given Id and given Management Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_data_source = oci.ManagementAgent.get_management_agent_data_source(data_source_key=var["management_agent_data_source_data_source_key"],
        management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"])
    ```


    :param str data_source_key: Data source type and name identifier.
    :param str management_agent_id: Unique Management Agent identifier
    """
    __args__ = dict()
    __args__['dataSourceKey'] = data_source_key
    __args__['managementAgentId'] = management_agent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentDataSource:getManagementAgentDataSource', __args__, opts=opts, typ=GetManagementAgentDataSourceResult).value

    return AwaitableGetManagementAgentDataSourceResult(
        allow_metrics=pulumi.get(__ret__, 'allow_metrics'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_timeout=pulumi.get(__ret__, 'connection_timeout'),
        data_source_key=pulumi.get(__ret__, 'data_source_key'),
        id=pulumi.get(__ret__, 'id'),
        is_daemon_set=pulumi.get(__ret__, 'is_daemon_set'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        metric_dimensions=pulumi.get(__ret__, 'metric_dimensions'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        proxy_url=pulumi.get(__ret__, 'proxy_url'),
        read_data_limit=pulumi.get(__ret__, 'read_data_limit'),
        read_data_limit_in_kilobytes=pulumi.get(__ret__, 'read_data_limit_in_kilobytes'),
        read_timeout=pulumi.get(__ret__, 'read_timeout'),
        resource_group=pulumi.get(__ret__, 'resource_group'),
        schedule_mins=pulumi.get(__ret__, 'schedule_mins'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        url=pulumi.get(__ret__, 'url'))


@_utilities.lift_output_func(get_management_agent_data_source)
def get_management_agent_data_source_output(data_source_key: Optional[pulumi.Input[str]] = None,
                                            management_agent_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementAgentDataSourceResult]:
    """
    This data source provides details about a specific Management Agent Data Source resource in Oracle Cloud Infrastructure Management Agent service.

    Get Datasource details for given Id and given Management Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_data_source = oci.ManagementAgent.get_management_agent_data_source(data_source_key=var["management_agent_data_source_data_source_key"],
        management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"])
    ```


    :param str data_source_key: Data source type and name identifier.
    :param str management_agent_id: Unique Management Agent identifier
    """
    ...
