# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import StrictBool, constr

from typing import Any, Dict, Optional

from gradientai.openapi.client.models.complete_model_body_params import CompleteModelBodyParams
from gradientai.openapi.client.models.complete_model_success import CompleteModelSuccess
from gradientai.openapi.client.models.create_model_body_params import CreateModelBodyParams
from gradientai.openapi.client.models.create_model_success import CreateModelSuccess
from gradientai.openapi.client.models.fine_tune_model_body_params import FineTuneModelBodyParams
from gradientai.openapi.client.models.fine_tune_model_success import FineTuneModelSuccess
from gradientai.openapi.client.models.get_model_success import GetModelSuccess
from gradientai.openapi.client.models.list_models_success import ListModelsSuccess

from gradientai.openapi.client.api_client import ApiClient
from gradientai.openapi.client.api_response import ApiResponse
from gradientai.openapi.client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ModelsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def complete_model(self, id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), complete_model_body_params : CompleteModelBodyParams, **kwargs) -> CompleteModelSuccess:  # noqa: E501
        """Complete model  # noqa: E501

        Completes your fine-tuned model with the specified prompt string. The model will generate a completion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.complete_model(id, x_gradient_workspace_id, complete_model_body_params, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param complete_model_body_params: (required)
        :type complete_model_body_params: CompleteModelBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CompleteModelSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the complete_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.complete_model_with_http_info(id, x_gradient_workspace_id, complete_model_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def complete_model_with_http_info(self, id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), complete_model_body_params : CompleteModelBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Complete model  # noqa: E501

        Completes your fine-tuned model with the specified prompt string. The model will generate a completion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.complete_model_with_http_info(id, x_gradient_workspace_id, complete_model_body_params, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param complete_model_body_params: (required)
        :type complete_model_body_params: CompleteModelBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CompleteModelSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_gradient_workspace_id',
            'complete_model_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['complete_model_body_params'] is not None:
            _body_params = _params['complete_model_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "CompleteModelSuccess",
            '4XX': "CompleteModelError",
        }

        return self.api_client.call_api(
            '/models/{id}/complete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_model(self, x_gradient_workspace_id : constr(strict=True, min_length=1), create_model_body_params : CreateModelBodyParams, **kwargs) -> CreateModelSuccess:  # noqa: E501
        """Create model  # noqa: E501

        Creates a new instance of a model based on a specified model from the existing list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_model(x_gradient_workspace_id, create_model_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param create_model_body_params: (required)
        :type create_model_body_params: CreateModelBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateModelSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_model_with_http_info(x_gradient_workspace_id, create_model_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def create_model_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), create_model_body_params : CreateModelBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Create model  # noqa: E501

        Creates a new instance of a model based on a specified model from the existing list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_model_with_http_info(x_gradient_workspace_id, create_model_body_params, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param create_model_body_params: (required)
        :type create_model_body_params: CreateModelBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateModelSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'create_model_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_model_body_params'] is not None:
            _body_params = _params['create_model_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "CreateModelSuccess",
            '4XX': "CreateModelError",
        }

        return self.api_client.call_api(
            '/models', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_model(self, id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), **kwargs) -> object:  # noqa: E501
        """Delete model.  # noqa: E501

        Deletes the fine-tuned model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_model(id, x_gradient_workspace_id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_model_with_http_info(id, x_gradient_workspace_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_model_with_http_info(self, id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), **kwargs) -> ApiResponse:  # noqa: E501
        """Delete model.  # noqa: E501

        Deletes the fine-tuned model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_model_with_http_info(id, x_gradient_workspace_id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_gradient_workspace_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '4XX': "DeleteModelError",
        }

        return self.api_client.call_api(
            '/models/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def fine_tune_model(self, id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), fine_tune_model_body_params : FineTuneModelBodyParams, **kwargs) -> FineTuneModelSuccess:  # noqa: E501
        """Fine-tune model  # noqa: E501

        Fine-tunes the specified model with your data samples.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fine_tune_model(id, x_gradient_workspace_id, fine_tune_model_body_params, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param fine_tune_model_body_params: (required)
        :type fine_tune_model_body_params: FineTuneModelBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FineTuneModelSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the fine_tune_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.fine_tune_model_with_http_info(id, x_gradient_workspace_id, fine_tune_model_body_params, **kwargs)  # noqa: E501

    @validate_arguments
    def fine_tune_model_with_http_info(self, id : constr(strict=True, min_length=1), x_gradient_workspace_id : constr(strict=True, min_length=1), fine_tune_model_body_params : FineTuneModelBodyParams, **kwargs) -> ApiResponse:  # noqa: E501
        """Fine-tune model  # noqa: E501

        Fine-tunes the specified model with your data samples.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fine_tune_model_with_http_info(id, x_gradient_workspace_id, fine_tune_model_body_params, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param fine_tune_model_body_params: (required)
        :type fine_tune_model_body_params: FineTuneModelBodyParams
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FineTuneModelSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_gradient_workspace_id',
            'fine_tune_model_body_params'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fine_tune_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fine_tune_model_body_params'] is not None:
            _body_params = _params['fine_tune_model_body_params']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "FineTuneModelSuccess",
            '4XX': "FineTuneModelError",
        }

        return self.api_client.call_api(
            '/models/{id}/fine-tune', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_model(self, id : constr(strict=True, max_length=50, min_length=50), x_gradient_workspace_id : constr(strict=True, min_length=1), **kwargs) -> GetModelSuccess:  # noqa: E501
        """Describe model  # noqa: E501

        Describes the specified model, including the model ID, name, and base model ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_model(id, x_gradient_workspace_id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetModelSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_model_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_model_with_http_info(id, x_gradient_workspace_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_model_with_http_info(self, id : constr(strict=True, max_length=50, min_length=50), x_gradient_workspace_id : constr(strict=True, min_length=1), **kwargs) -> ApiResponse:  # noqa: E501
        """Describe model  # noqa: E501

        Describes the specified model, including the model ID, name, and base model ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_model_with_http_info(id, x_gradient_workspace_id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetModelSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_gradient_workspace_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "GetModelSuccess",
            '4XX': "GetModelError",
        }

        return self.api_client.call_api(
            '/models/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_models(self, x_gradient_workspace_id : constr(strict=True, min_length=1), only_base : Optional[StrictBool] = None, **kwargs) -> ListModelsSuccess:  # noqa: E501
        """List available models  # noqa: E501

        Lists the currently available models in the selected workspace and provides basic information, such as the model name, ID and whether it is a base or fine-tuned model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_models(x_gradient_workspace_id, only_base, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param only_base:
        :type only_base: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListModelsSuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_models_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_models_with_http_info(x_gradient_workspace_id, only_base, **kwargs)  # noqa: E501

    @validate_arguments
    def list_models_with_http_info(self, x_gradient_workspace_id : constr(strict=True, min_length=1), only_base : Optional[StrictBool] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List available models  # noqa: E501

        Lists the currently available models in the selected workspace and provides basic information, such as the model name, ID and whether it is a base or fine-tuned model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_models_with_http_info(x_gradient_workspace_id, only_base, async_req=True)
        >>> result = thread.get()

        :param x_gradient_workspace_id: (required)
        :type x_gradient_workspace_id: str
        :param only_base:
        :type only_base: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListModelsSuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_gradient_workspace_id',
            'only_base'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_models" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('only_base') is not None:  # noqa: E501
            _query_params.append(('onlyBase', _params['only_base']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_gradient_workspace_id']:
            _header_params['x-gradient-workspace-id'] = _params['x_gradient_workspace_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['AccessToken']  # noqa: E501

        _response_types_map = {
            '200': "ListModelsSuccess",
            '4XX': "ListModelsError",
        }

        return self.api_client.call_api(
            '/models', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
