# gradientai.openapi.client.EmbeddingsApi

All URIs are relative to *https://api.gradient.ai/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**generate_embedding**](EmbeddingsApi.md#generate_embedding) | **POST** /embeddings/{slug} | Generate embeddings
[**list_embeddings**](EmbeddingsApi.md#list_embeddings) | **GET** /embeddings | List available embeddings models


# **generate_embedding**
> GenerateEmbeddingSuccess generate_embedding(slug, x_gradient_workspace_id, generate_embedding_body_params)

Generate embeddings

Generates embeddings with the given embeddings model.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.generate_embedding_body_params import GenerateEmbeddingBodyParams
from gradientai.openapi.client.models.generate_embedding_success import GenerateEmbeddingSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.EmbeddingsApi(api_client)
    slug = 'slug_example' # str | 
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    generate_embedding_body_params = gradientai.openapi.client.GenerateEmbeddingBodyParams() # GenerateEmbeddingBodyParams | 

    try:
        # Generate embeddings
        api_response = api_instance.generate_embedding(slug, x_gradient_workspace_id, generate_embedding_body_params)
        print("The response of EmbeddingsApi->generate_embedding:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling EmbeddingsApi->generate_embedding: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **str**|  | 
 **x_gradient_workspace_id** | **str**|  | 
 **generate_embedding_body_params** | [**GenerateEmbeddingBodyParams**](GenerateEmbeddingBodyParams.md)|  | 

### Return type

[**GenerateEmbeddingSuccess**](GenerateEmbeddingSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_embeddings**
> ListEmbeddingsSuccess list_embeddings(x_gradient_workspace_id)

List available embeddings models

Lists the currently available embeddings models and provides basic information, such as the slug.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.list_embeddings_success import ListEmbeddingsSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.EmbeddingsApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 

    try:
        # List available embeddings models
        api_response = api_instance.list_embeddings(x_gradient_workspace_id)
        print("The response of EmbeddingsApi->list_embeddings:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling EmbeddingsApi->list_embeddings: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 

### Return type

[**ListEmbeddingsSuccess**](ListEmbeddingsSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

