# gradientai.openapi.client
Interface for interacting with Gradient AI.

The `gradientai.openapi.client` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://docs.gradient.ai/discuss](https://docs.gradient.ai/discuss)

## Requirements.

Python 3.7+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3
* python-dateutil
* pydantic
* aenum

## Getting Started

In your own code, to use this library to connect and interact with gradientai.openapi.client,
you can run the following:

```python

import time
import gradientai.openapi.client
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.EmbeddingsApi(api_client)
    slug = 'slug_example' # str | 
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    generate_embedding_body_params = gradientai.openapi.client.GenerateEmbeddingBodyParams() # GenerateEmbeddingBodyParams | 

    try:
        # Generate embeddings
        api_response = api_instance.generate_embedding(slug, x_gradient_workspace_id, generate_embedding_body_params)
        print("The response of EmbeddingsApi->generate_embedding:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling EmbeddingsApi->generate_embedding: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EmbeddingsApi* | [**generate_embedding**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/EmbeddingsApi.md#generate_embedding) | **POST** /embeddings/{slug} | Generate embeddings
*EmbeddingsApi* | [**list_embeddings**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/EmbeddingsApi.md#list_embeddings) | **GET** /embeddings | List available embeddings models
*ModelsApi* | [**complete_model**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelsApi.md#complete_model) | **POST** /models/{id}/complete | Complete model
*ModelsApi* | [**create_model**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelsApi.md#create_model) | **POST** /models | Create model
*ModelsApi* | [**delete_model**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelsApi.md#delete_model) | **DELETE** /models/{id} | Delete model.
*ModelsApi* | [**fine_tune_model**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelsApi.md#fine_tune_model) | **POST** /models/{id}/fine-tune | Fine-tune model
*ModelsApi* | [**get_model**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelsApi.md#get_model) | **GET** /models/{id} | Describe model
*ModelsApi* | [**list_models**](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelsApi.md#list_models) | **GET** /models | List available models


## Documentation For Models

 - [BaseModel](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/BaseModel.md)
 - [CompleteModelBodyParams](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelBodyParams.md)
 - [CompleteModelError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelError.md)
 - [CompleteModelErrorOneOf](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf.md)
 - [CompleteModelErrorOneOf1](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf1.md)
 - [CompleteModelErrorOneOf1Payload](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf1Payload.md)
 - [CompleteModelErrorOneOf2](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf2.md)
 - [CompleteModelErrorOneOf3](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf3.md)
 - [CompleteModelErrorOneOf4](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf4.md)
 - [CompleteModelErrorOneOf5](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOf5.md)
 - [CompleteModelErrorOneOfPayload](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOfPayload.md)
 - [CompleteModelErrorOneOfPayloadFlaggedContentInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelErrorOneOfPayloadFlaggedContentInner.md)
 - [CompleteModelSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CompleteModelSuccess.md)
 - [CreateModelBodyParams](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelBodyParams.md)
 - [CreateModelBodyParamsInitialHyperparameters](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelBodyParamsInitialHyperparameters.md)
 - [CreateModelBodyParamsInitialHyperparametersLoraHyperparameters](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelBodyParamsInitialHyperparametersLoraHyperparameters.md)
 - [CreateModelBodyParamsInitialHyperparametersTrainingArguments](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelBodyParamsInitialHyperparametersTrainingArguments.md)
 - [CreateModelBodyParamsModel](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelBodyParamsModel.md)
 - [CreateModelError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelError.md)
 - [CreateModelSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/CreateModelSuccess.md)
 - [DeleteModelError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/DeleteModelError.md)
 - [FineTuneModelBodyParams](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelBodyParams.md)
 - [FineTuneModelBodyParamsSamplesInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelBodyParamsSamplesInner.md)
 - [FineTuneModelBodyParamsSamplesInnerFineTuningParameters](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelBodyParamsSamplesInnerFineTuningParameters.md)
 - [FineTuneModelBodyParamsSamplesInnerInputs](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelBodyParamsSamplesInnerInputs.md)
 - [FineTuneModelBodyParamsSamplesInnerInputsAnyOfInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelBodyParamsSamplesInnerInputsAnyOfInner.md)
 - [FineTuneModelError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelError.md)
 - [FineTuneModelErrorOneOf](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelErrorOneOf.md)
 - [FineTuneModelSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/FineTuneModelSuccess.md)
 - [GenerateEmbeddingBodyParams](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GenerateEmbeddingBodyParams.md)
 - [GenerateEmbeddingBodyParamsInputsInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GenerateEmbeddingBodyParamsInputsInner.md)
 - [GenerateEmbeddingError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GenerateEmbeddingError.md)
 - [GenerateEmbeddingSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GenerateEmbeddingSuccess.md)
 - [GenerateEmbeddingSuccessEmbeddingsInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GenerateEmbeddingSuccessEmbeddingsInner.md)
 - [GetModelError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GetModelError.md)
 - [GetModelSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/GetModelSuccess.md)
 - [ListEmbeddingsError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ListEmbeddingsError.md)
 - [ListEmbeddingsSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ListEmbeddingsSuccess.md)
 - [ListEmbeddingsSuccessEmbeddingsModelsInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ListEmbeddingsSuccessEmbeddingsModelsInner.md)
 - [ListModelsError](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ListModelsError.md)
 - [ListModelsSuccess](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ListModelsSuccess.md)
 - [ListModelsSuccessModelsInner](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ListModelsSuccessModelsInner.md)
 - [ModelAdapter](https://github.com/Preemo-Inc/gradientai-python-sdk/blob/main/gradientai/openapi/client/docs/ModelAdapter.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="AccessToken"></a>
### AccessToken

- **Type**: Bearer authentication


## Author

support@gradient.ai


