# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduleResult',
    'AwaitableGetScheduleResult',
    'get_schedule',
    'get_schedule_output',
]

@pulumi.output_type
class GetScheduleResult:
    """
    A collection of values returned by getSchedule.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, name=None, output_file_format=None, query_properties=None, result_locations=None, saved_report_id=None, schedule_id=None, schedule_recurrences=None, state=None, system_tags=None, time_created=None, time_next_run=None, time_scheduled=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_file_format and not isinstance(output_file_format, str):
            raise TypeError("Expected argument 'output_file_format' to be a str")
        pulumi.set(__self__, "output_file_format", output_file_format)
        if query_properties and not isinstance(query_properties, list):
            raise TypeError("Expected argument 'query_properties' to be a list")
        pulumi.set(__self__, "query_properties", query_properties)
        if result_locations and not isinstance(result_locations, list):
            raise TypeError("Expected argument 'result_locations' to be a list")
        pulumi.set(__self__, "result_locations", result_locations)
        if saved_report_id and not isinstance(saved_report_id, str):
            raise TypeError("Expected argument 'saved_report_id' to be a str")
        pulumi.set(__self__, "saved_report_id", saved_report_id)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if schedule_recurrences and not isinstance(schedule_recurrences, str):
            raise TypeError("Expected argument 'schedule_recurrences' to be a str")
        pulumi.set(__self__, "schedule_recurrences", schedule_recurrences)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_next_run and not isinstance(time_next_run, str):
            raise TypeError("Expected argument 'time_next_run' to be a str")
        pulumi.set(__self__, "time_next_run", time_next_run)
        if time_scheduled and not isinstance(time_scheduled, str):
            raise TypeError("Expected argument 'time_scheduled' to be a str")
        pulumi.set(__self__, "time_scheduled", time_scheduled)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID representing a unique shedule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the schedule created by the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputFileFormat")
    def output_file_format(self) -> str:
        """
        Specifies supported output file format.
        """
        return pulumi.get(self, "output_file_format")

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> Sequence['outputs.GetScheduleQueryPropertyResult']:
        """
        The query properties.
        """
        return pulumi.get(self, "query_properties")

    @property
    @pulumi.getter(name="resultLocations")
    def result_locations(self) -> Sequence['outputs.GetScheduleResultLocationResult']:
        """
        The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        """
        return pulumi.get(self, "result_locations")

    @property
    @pulumi.getter(name="savedReportId")
    def saved_report_id(self) -> str:
        """
        The saved report id which can also be used to generate query.
        """
        return pulumi.get(self, "saved_report_id")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> str:
        return pulumi.get(self, "schedule_id")

    @property
    @pulumi.getter(name="scheduleRecurrences")
    def schedule_recurrences(self) -> str:
        """
        Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        """
        return pulumi.get(self, "schedule_recurrences")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The schedule lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the schedule was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> str:
        """
        The date and time of the next job execution.
        """
        return pulumi.get(self, "time_next_run")

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> str:
        """
        The date and time of the first time job execution.
        """
        return pulumi.get(self, "time_scheduled")


class AwaitableGetScheduleResult(GetScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduleResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            name=self.name,
            output_file_format=self.output_file_format,
            query_properties=self.query_properties,
            result_locations=self.result_locations,
            saved_report_id=self.saved_report_id,
            schedule_id=self.schedule_id,
            schedule_recurrences=self.schedule_recurrences,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_next_run=self.time_next_run,
            time_scheduled=self.time_scheduled)


def get_schedule(schedule_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduleResult:
    """
    This data source provides details about a specific Schedule resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved schedule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedule = oci.MeteringComputation.get_schedule(schedule_id=oci_metering_computation_schedule["test_schedule"]["id"])
    ```


    :param str schedule_id: The schedule unique OCID.
    """
    __args__ = dict()
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult).value

    return AwaitableGetScheduleResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        output_file_format=pulumi.get(__ret__, 'output_file_format'),
        query_properties=pulumi.get(__ret__, 'query_properties'),
        result_locations=pulumi.get(__ret__, 'result_locations'),
        saved_report_id=pulumi.get(__ret__, 'saved_report_id'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        schedule_recurrences=pulumi.get(__ret__, 'schedule_recurrences'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_next_run=pulumi.get(__ret__, 'time_next_run'),
        time_scheduled=pulumi.get(__ret__, 'time_scheduled'))


@_utilities.lift_output_func(get_schedule)
def get_schedule_output(schedule_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScheduleResult]:
    """
    This data source provides details about a specific Schedule resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved schedule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedule = oci.MeteringComputation.get_schedule(schedule_id=oci_metering_computation_schedule["test_schedule"]["id"])
    ```


    :param str schedule_id: The schedule unique OCID.
    """
    ...
