# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.add_knowledge_base_response_model import AddKnowledgeBaseResponseModel
from ..types.post_workspace_secret_response_model import PostWorkspaceSecretResponseModel
from ..types.rag_document_index_response_model import RagDocumentIndexResponseModel
from ..types.rag_document_indexes_response_model import RagDocumentIndexesResponseModel
from ..types.rag_index_overview_response_model import RagIndexOverviewResponseModel
from .raw_client import AsyncRawConversationalAiClient, RawConversationalAiClient

if typing.TYPE_CHECKING:
    from .agents.client import AgentsClient, AsyncAgentsClient
    from .batch_calls.client import AsyncBatchCallsClient, BatchCallsClient
    from .conversations.client import AsyncConversationsClient, ConversationsClient
    from .dashboard.client import AsyncDashboardClient, DashboardClient
    from .knowledge_base.client import AsyncKnowledgeBaseClient, KnowledgeBaseClient
    from .llm_usage.client import AsyncLlmUsageClient, LlmUsageClient
    from .mcp_servers.client import AsyncMcpServersClient, McpServersClient
    from .phone_numbers.client import AsyncPhoneNumbersClient, PhoneNumbersClient
    from .secrets.client import AsyncSecretsClient, SecretsClient
    from .settings.client import AsyncSettingsClient, SettingsClient
    from .sip_trunk.client import AsyncSipTrunkClient, SipTrunkClient
    from .tests.client import AsyncTestsClient, TestsClient
    from .tools.client import AsyncToolsClient, ToolsClient
    from .twilio.client import AsyncTwilioClient, TwilioClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConversationalAiClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConversationalAiClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._conversations: typing.Optional[ConversationsClient] = None
        self._twilio: typing.Optional[TwilioClient] = None
        self._agents: typing.Optional[AgentsClient] = None
        self._tests: typing.Optional[TestsClient] = None
        self._phone_numbers: typing.Optional[PhoneNumbersClient] = None
        self._llm_usage: typing.Optional[LlmUsageClient] = None
        self._knowledge_base: typing.Optional[KnowledgeBaseClient] = None
        self._tools: typing.Optional[ToolsClient] = None
        self._settings: typing.Optional[SettingsClient] = None
        self._secrets: typing.Optional[SecretsClient] = None
        self._batch_calls: typing.Optional[BatchCallsClient] = None
        self._sip_trunk: typing.Optional[SipTrunkClient] = None
        self._mcp_servers: typing.Optional[McpServersClient] = None
        self._dashboard: typing.Optional[DashboardClient] = None

    @property
    def with_raw_response(self) -> RawConversationalAiClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConversationalAiClient
        """
        return self._raw_client

    def add_to_knowledge_base(
        self,
        *,
        agent_id: typing.Optional[str] = None,
        name: typing.Optional[str] = OMIT,
        url: typing.Optional[str] = OMIT,
        file: typing.Optional[core.File] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddKnowledgeBaseResponseModel:
        """
        Upload a file or webpage URL to create a knowledge base document. <br> <Note> After creating the document, update the agent's knowledge base by calling [Update agent](/docs/api-reference/agents/update). </Note>

        Parameters
        ----------
        agent_id : typing.Optional[str]

        name : typing.Optional[str]
            A custom, human-readable name for the document.

        url : typing.Optional[str]
            URL to a page of documentation that the agent will have access to in order to interact with users.

        file : typing.Optional[core.File]
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddKnowledgeBaseResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.add_to_knowledge_base()
        """
        _response = self._raw_client.add_to_knowledge_base(
            agent_id=agent_id, name=name, url=url, file=file, request_options=request_options
        )
        return _response.data

    def get_document_rag_indexes(
        self, documentation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RagDocumentIndexesResponseModel:
        """
        Provides information about all RAG indexes of the specified knowledgebase document.

        Parameters
        ----------
        documentation_id : str
            The id of a document from the knowledge base. This is returned on document addition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RagDocumentIndexesResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.get_document_rag_indexes(
            documentation_id="21m00Tcm4TlvDq8ikWAM",
        )
        """
        _response = self._raw_client.get_document_rag_indexes(documentation_id, request_options=request_options)
        return _response.data

    def delete_document_rag_index(
        self, documentation_id: str, rag_index_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RagDocumentIndexResponseModel:
        """
        Delete RAG index for the knowledgebase document.

        Parameters
        ----------
        documentation_id : str
            The id of a document from the knowledge base. This is returned on document addition.

        rag_index_id : str
            The id of RAG index of document from the knowledge base.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RagDocumentIndexResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.delete_document_rag_index(
            documentation_id="21m00Tcm4TlvDq8ikWAM",
            rag_index_id="21m00Tcm4TlvDq8ikWAM",
        )
        """
        _response = self._raw_client.delete_document_rag_index(
            documentation_id, rag_index_id, request_options=request_options
        )
        return _response.data

    def rag_index_overview(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RagIndexOverviewResponseModel:
        """
        Provides total size and other information of RAG indexes used by knowledgebase documents

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RagIndexOverviewResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.rag_index_overview()
        """
        _response = self._raw_client.rag_index_overview(request_options=request_options)
        return _response.data

    def update_secret(
        self, secret_id: str, *, name: str, value: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PostWorkspaceSecretResponseModel:
        """
        Update an existing secret for the workspace

        Parameters
        ----------
        secret_id : str

        name : str

        value : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostWorkspaceSecretResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.update_secret(
            secret_id="secret_id",
            name="name",
            value="value",
        )
        """
        _response = self._raw_client.update_secret(secret_id, name=name, value=value, request_options=request_options)
        return _response.data

    @property
    def conversations(self):
        if self._conversations is None:
            from .conversations.client import ConversationsClient  # noqa: E402

            self._conversations = ConversationsClient(client_wrapper=self._client_wrapper)
        return self._conversations

    @property
    def twilio(self):
        if self._twilio is None:
            from .twilio.client import TwilioClient  # noqa: E402

            self._twilio = TwilioClient(client_wrapper=self._client_wrapper)
        return self._twilio

    @property
    def agents(self):
        if self._agents is None:
            from .agents.client import AgentsClient  # noqa: E402

            self._agents = AgentsClient(client_wrapper=self._client_wrapper)
        return self._agents

    @property
    def tests(self):
        if self._tests is None:
            from .tests.client import TestsClient  # noqa: E402

            self._tests = TestsClient(client_wrapper=self._client_wrapper)
        return self._tests

    @property
    def phone_numbers(self):
        if self._phone_numbers is None:
            from .phone_numbers.client import PhoneNumbersClient  # noqa: E402

            self._phone_numbers = PhoneNumbersClient(client_wrapper=self._client_wrapper)
        return self._phone_numbers

    @property
    def llm_usage(self):
        if self._llm_usage is None:
            from .llm_usage.client import LlmUsageClient  # noqa: E402

            self._llm_usage = LlmUsageClient(client_wrapper=self._client_wrapper)
        return self._llm_usage

    @property
    def knowledge_base(self):
        if self._knowledge_base is None:
            from .knowledge_base.client import KnowledgeBaseClient  # noqa: E402

            self._knowledge_base = KnowledgeBaseClient(client_wrapper=self._client_wrapper)
        return self._knowledge_base

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import ToolsClient  # noqa: E402

            self._tools = ToolsClient(client_wrapper=self._client_wrapper)
        return self._tools

    @property
    def settings(self):
        if self._settings is None:
            from .settings.client import SettingsClient  # noqa: E402

            self._settings = SettingsClient(client_wrapper=self._client_wrapper)
        return self._settings

    @property
    def secrets(self):
        if self._secrets is None:
            from .secrets.client import SecretsClient  # noqa: E402

            self._secrets = SecretsClient(client_wrapper=self._client_wrapper)
        return self._secrets

    @property
    def batch_calls(self):
        if self._batch_calls is None:
            from .batch_calls.client import BatchCallsClient  # noqa: E402

            self._batch_calls = BatchCallsClient(client_wrapper=self._client_wrapper)
        return self._batch_calls

    @property
    def sip_trunk(self):
        if self._sip_trunk is None:
            from .sip_trunk.client import SipTrunkClient  # noqa: E402

            self._sip_trunk = SipTrunkClient(client_wrapper=self._client_wrapper)
        return self._sip_trunk

    @property
    def mcp_servers(self):
        if self._mcp_servers is None:
            from .mcp_servers.client import McpServersClient  # noqa: E402

            self._mcp_servers = McpServersClient(client_wrapper=self._client_wrapper)
        return self._mcp_servers

    @property
    def dashboard(self):
        if self._dashboard is None:
            from .dashboard.client import DashboardClient  # noqa: E402

            self._dashboard = DashboardClient(client_wrapper=self._client_wrapper)
        return self._dashboard


class AsyncConversationalAiClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConversationalAiClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._conversations: typing.Optional[AsyncConversationsClient] = None
        self._twilio: typing.Optional[AsyncTwilioClient] = None
        self._agents: typing.Optional[AsyncAgentsClient] = None
        self._tests: typing.Optional[AsyncTestsClient] = None
        self._phone_numbers: typing.Optional[AsyncPhoneNumbersClient] = None
        self._llm_usage: typing.Optional[AsyncLlmUsageClient] = None
        self._knowledge_base: typing.Optional[AsyncKnowledgeBaseClient] = None
        self._tools: typing.Optional[AsyncToolsClient] = None
        self._settings: typing.Optional[AsyncSettingsClient] = None
        self._secrets: typing.Optional[AsyncSecretsClient] = None
        self._batch_calls: typing.Optional[AsyncBatchCallsClient] = None
        self._sip_trunk: typing.Optional[AsyncSipTrunkClient] = None
        self._mcp_servers: typing.Optional[AsyncMcpServersClient] = None
        self._dashboard: typing.Optional[AsyncDashboardClient] = None

    @property
    def with_raw_response(self) -> AsyncRawConversationalAiClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConversationalAiClient
        """
        return self._raw_client

    async def add_to_knowledge_base(
        self,
        *,
        agent_id: typing.Optional[str] = None,
        name: typing.Optional[str] = OMIT,
        url: typing.Optional[str] = OMIT,
        file: typing.Optional[core.File] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddKnowledgeBaseResponseModel:
        """
        Upload a file or webpage URL to create a knowledge base document. <br> <Note> After creating the document, update the agent's knowledge base by calling [Update agent](/docs/api-reference/agents/update). </Note>

        Parameters
        ----------
        agent_id : typing.Optional[str]

        name : typing.Optional[str]
            A custom, human-readable name for the document.

        url : typing.Optional[str]
            URL to a page of documentation that the agent will have access to in order to interact with users.

        file : typing.Optional[core.File]
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddKnowledgeBaseResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.add_to_knowledge_base()


        asyncio.run(main())
        """
        _response = await self._raw_client.add_to_knowledge_base(
            agent_id=agent_id, name=name, url=url, file=file, request_options=request_options
        )
        return _response.data

    async def get_document_rag_indexes(
        self, documentation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RagDocumentIndexesResponseModel:
        """
        Provides information about all RAG indexes of the specified knowledgebase document.

        Parameters
        ----------
        documentation_id : str
            The id of a document from the knowledge base. This is returned on document addition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RagDocumentIndexesResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.get_document_rag_indexes(
                documentation_id="21m00Tcm4TlvDq8ikWAM",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_document_rag_indexes(documentation_id, request_options=request_options)
        return _response.data

    async def delete_document_rag_index(
        self, documentation_id: str, rag_index_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RagDocumentIndexResponseModel:
        """
        Delete RAG index for the knowledgebase document.

        Parameters
        ----------
        documentation_id : str
            The id of a document from the knowledge base. This is returned on document addition.

        rag_index_id : str
            The id of RAG index of document from the knowledge base.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RagDocumentIndexResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.delete_document_rag_index(
                documentation_id="21m00Tcm4TlvDq8ikWAM",
                rag_index_id="21m00Tcm4TlvDq8ikWAM",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_document_rag_index(
            documentation_id, rag_index_id, request_options=request_options
        )
        return _response.data

    async def rag_index_overview(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RagIndexOverviewResponseModel:
        """
        Provides total size and other information of RAG indexes used by knowledgebase documents

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RagIndexOverviewResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.rag_index_overview()


        asyncio.run(main())
        """
        _response = await self._raw_client.rag_index_overview(request_options=request_options)
        return _response.data

    async def update_secret(
        self, secret_id: str, *, name: str, value: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PostWorkspaceSecretResponseModel:
        """
        Update an existing secret for the workspace

        Parameters
        ----------
        secret_id : str

        name : str

        value : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostWorkspaceSecretResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.update_secret(
                secret_id="secret_id",
                name="name",
                value="value",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_secret(
            secret_id, name=name, value=value, request_options=request_options
        )
        return _response.data

    @property
    def conversations(self):
        if self._conversations is None:
            from .conversations.client import AsyncConversationsClient  # noqa: E402

            self._conversations = AsyncConversationsClient(client_wrapper=self._client_wrapper)
        return self._conversations

    @property
    def twilio(self):
        if self._twilio is None:
            from .twilio.client import AsyncTwilioClient  # noqa: E402

            self._twilio = AsyncTwilioClient(client_wrapper=self._client_wrapper)
        return self._twilio

    @property
    def agents(self):
        if self._agents is None:
            from .agents.client import AsyncAgentsClient  # noqa: E402

            self._agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)
        return self._agents

    @property
    def tests(self):
        if self._tests is None:
            from .tests.client import AsyncTestsClient  # noqa: E402

            self._tests = AsyncTestsClient(client_wrapper=self._client_wrapper)
        return self._tests

    @property
    def phone_numbers(self):
        if self._phone_numbers is None:
            from .phone_numbers.client import AsyncPhoneNumbersClient  # noqa: E402

            self._phone_numbers = AsyncPhoneNumbersClient(client_wrapper=self._client_wrapper)
        return self._phone_numbers

    @property
    def llm_usage(self):
        if self._llm_usage is None:
            from .llm_usage.client import AsyncLlmUsageClient  # noqa: E402

            self._llm_usage = AsyncLlmUsageClient(client_wrapper=self._client_wrapper)
        return self._llm_usage

    @property
    def knowledge_base(self):
        if self._knowledge_base is None:
            from .knowledge_base.client import AsyncKnowledgeBaseClient  # noqa: E402

            self._knowledge_base = AsyncKnowledgeBaseClient(client_wrapper=self._client_wrapper)
        return self._knowledge_base

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import AsyncToolsClient  # noqa: E402

            self._tools = AsyncToolsClient(client_wrapper=self._client_wrapper)
        return self._tools

    @property
    def settings(self):
        if self._settings is None:
            from .settings.client import AsyncSettingsClient  # noqa: E402

            self._settings = AsyncSettingsClient(client_wrapper=self._client_wrapper)
        return self._settings

    @property
    def secrets(self):
        if self._secrets is None:
            from .secrets.client import AsyncSecretsClient  # noqa: E402

            self._secrets = AsyncSecretsClient(client_wrapper=self._client_wrapper)
        return self._secrets

    @property
    def batch_calls(self):
        if self._batch_calls is None:
            from .batch_calls.client import AsyncBatchCallsClient  # noqa: E402

            self._batch_calls = AsyncBatchCallsClient(client_wrapper=self._client_wrapper)
        return self._batch_calls

    @property
    def sip_trunk(self):
        if self._sip_trunk is None:
            from .sip_trunk.client import AsyncSipTrunkClient  # noqa: E402

            self._sip_trunk = AsyncSipTrunkClient(client_wrapper=self._client_wrapper)
        return self._sip_trunk

    @property
    def mcp_servers(self):
        if self._mcp_servers is None:
            from .mcp_servers.client import AsyncMcpServersClient  # noqa: E402

            self._mcp_servers = AsyncMcpServersClient(client_wrapper=self._client_wrapper)
        return self._mcp_servers

    @property
    def dashboard(self):
        if self._dashboard is None:
            from .dashboard.client import AsyncDashboardClient  # noqa: E402

            self._dashboard = AsyncDashboardClient(client_wrapper=self._client_wrapper)
        return self._dashboard
