# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.conversation_signed_url_response_model import ConversationSignedUrlResponseModel
from ...types.evaluation_success_result import EvaluationSuccessResult
from ...types.get_conversation_response_model import GetConversationResponseModel
from ...types.get_conversations_page_response_model import GetConversationsPageResponseModel
from ...types.token_response_model import TokenResponseModel
from .raw_client import AsyncRawConversationsClient, RawConversationsClient
from .types.conversations_list_request_summary_mode import ConversationsListRequestSummaryMode

if typing.TYPE_CHECKING:
    from .audio.client import AsyncAudioClient, AudioClient
    from .feedback.client import AsyncFeedbackClient, FeedbackClient


class ConversationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConversationsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._audio: typing.Optional[AudioClient] = None
        self._feedback: typing.Optional[FeedbackClient] = None

    @property
    def with_raw_response(self) -> RawConversationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConversationsClient
        """
        return self._raw_client

    def get_signed_url(
        self,
        *,
        agent_id: str,
        include_conversation_id: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationSignedUrlResponseModel:
        """
        Get a signed url to start a conversation with an agent with an agent that requires authorization

        Parameters
        ----------
        agent_id : str
            The id of the agent you're taking the action on.

        include_conversation_id : typing.Optional[bool]
            Whether to include a conversation_id with the response. If included, the conversation_signature cannot be used again.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationSignedUrlResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.conversations.get_signed_url(
            agent_id="21m00Tcm4TlvDq8ikWAM",
        )
        """
        _response = self._raw_client.get_signed_url(
            agent_id=agent_id, include_conversation_id=include_conversation_id, request_options=request_options
        )
        return _response.data

    def get_webrtc_token(
        self,
        *,
        agent_id: str,
        participant_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TokenResponseModel:
        """
        Get a WebRTC session token for real-time communication.

        Parameters
        ----------
        agent_id : str
            The id of the agent you're taking the action on.

        participant_name : typing.Optional[str]
            Optional custom participant name. If not provided, user ID will be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TokenResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.conversations.get_webrtc_token(
            agent_id="21m00Tcm4TlvDq8ikWAM",
        )
        """
        _response = self._raw_client.get_webrtc_token(
            agent_id=agent_id, participant_name=participant_name, request_options=request_options
        )
        return _response.data

    def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        call_successful: typing.Optional[EvaluationSuccessResult] = None,
        call_start_before_unix: typing.Optional[int] = None,
        call_start_after_unix: typing.Optional[int] = None,
        user_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        summary_mode: typing.Optional[ConversationsListRequestSummaryMode] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetConversationsPageResponseModel:
        """
        Get all conversations of agents that user owns. With option to restrict to a specific agent.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        agent_id : typing.Optional[str]
            The id of the agent you're taking the action on.

        call_successful : typing.Optional[EvaluationSuccessResult]
            The result of the success evaluation

        call_start_before_unix : typing.Optional[int]
            Unix timestamp (in seconds) to filter conversations up to this start date.

        call_start_after_unix : typing.Optional[int]
            Unix timestamp (in seconds) to filter conversations after to this start date.

        user_id : typing.Optional[str]
            Filter conversations by the user ID who initiated them.

        page_size : typing.Optional[int]
            How many conversations to return at maximum. Can not exceed 100, defaults to 30.

        summary_mode : typing.Optional[ConversationsListRequestSummaryMode]
            Whether to include transcript summaries in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConversationsPageResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.conversations.list()
        """
        _response = self._raw_client.list(
            cursor=cursor,
            agent_id=agent_id,
            call_successful=call_successful,
            call_start_before_unix=call_start_before_unix,
            call_start_after_unix=call_start_after_unix,
            user_id=user_id,
            page_size=page_size,
            summary_mode=summary_mode,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, conversation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConversationResponseModel:
        """
        Get the details of a particular conversation

        Parameters
        ----------
        conversation_id : str
            The id of the conversation you're taking the action on.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConversationResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.conversations.get(
            conversation_id="123",
        )
        """
        _response = self._raw_client.get(conversation_id, request_options=request_options)
        return _response.data

    def delete(
        self, conversation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a particular conversation

        Parameters
        ----------
        conversation_id : str
            The id of the conversation you're taking the action on.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.conversations.delete(
            conversation_id="21m00Tcm4TlvDq8ikWAM",
        )
        """
        _response = self._raw_client.delete(conversation_id, request_options=request_options)
        return _response.data

    @property
    def audio(self):
        if self._audio is None:
            from .audio.client import AudioClient  # noqa: E402

            self._audio = AudioClient(client_wrapper=self._client_wrapper)
        return self._audio

    @property
    def feedback(self):
        if self._feedback is None:
            from .feedback.client import FeedbackClient  # noqa: E402

            self._feedback = FeedbackClient(client_wrapper=self._client_wrapper)
        return self._feedback


class AsyncConversationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConversationsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._audio: typing.Optional[AsyncAudioClient] = None
        self._feedback: typing.Optional[AsyncFeedbackClient] = None

    @property
    def with_raw_response(self) -> AsyncRawConversationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConversationsClient
        """
        return self._raw_client

    async def get_signed_url(
        self,
        *,
        agent_id: str,
        include_conversation_id: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationSignedUrlResponseModel:
        """
        Get a signed url to start a conversation with an agent with an agent that requires authorization

        Parameters
        ----------
        agent_id : str
            The id of the agent you're taking the action on.

        include_conversation_id : typing.Optional[bool]
            Whether to include a conversation_id with the response. If included, the conversation_signature cannot be used again.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationSignedUrlResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.conversations.get_signed_url(
                agent_id="21m00Tcm4TlvDq8ikWAM",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_signed_url(
            agent_id=agent_id, include_conversation_id=include_conversation_id, request_options=request_options
        )
        return _response.data

    async def get_webrtc_token(
        self,
        *,
        agent_id: str,
        participant_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TokenResponseModel:
        """
        Get a WebRTC session token for real-time communication.

        Parameters
        ----------
        agent_id : str
            The id of the agent you're taking the action on.

        participant_name : typing.Optional[str]
            Optional custom participant name. If not provided, user ID will be used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TokenResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.conversations.get_webrtc_token(
                agent_id="21m00Tcm4TlvDq8ikWAM",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_webrtc_token(
            agent_id=agent_id, participant_name=participant_name, request_options=request_options
        )
        return _response.data

    async def list(
        self,
        *,
        cursor: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        call_successful: typing.Optional[EvaluationSuccessResult] = None,
        call_start_before_unix: typing.Optional[int] = None,
        call_start_after_unix: typing.Optional[int] = None,
        user_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        summary_mode: typing.Optional[ConversationsListRequestSummaryMode] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetConversationsPageResponseModel:
        """
        Get all conversations of agents that user owns. With option to restrict to a specific agent.

        Parameters
        ----------
        cursor : typing.Optional[str]
            Used for fetching next page. Cursor is returned in the response.

        agent_id : typing.Optional[str]
            The id of the agent you're taking the action on.

        call_successful : typing.Optional[EvaluationSuccessResult]
            The result of the success evaluation

        call_start_before_unix : typing.Optional[int]
            Unix timestamp (in seconds) to filter conversations up to this start date.

        call_start_after_unix : typing.Optional[int]
            Unix timestamp (in seconds) to filter conversations after to this start date.

        user_id : typing.Optional[str]
            Filter conversations by the user ID who initiated them.

        page_size : typing.Optional[int]
            How many conversations to return at maximum. Can not exceed 100, defaults to 30.

        summary_mode : typing.Optional[ConversationsListRequestSummaryMode]
            Whether to include transcript summaries in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConversationsPageResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.conversations.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            cursor=cursor,
            agent_id=agent_id,
            call_successful=call_successful,
            call_start_before_unix=call_start_before_unix,
            call_start_after_unix=call_start_after_unix,
            user_id=user_id,
            page_size=page_size,
            summary_mode=summary_mode,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, conversation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConversationResponseModel:
        """
        Get the details of a particular conversation

        Parameters
        ----------
        conversation_id : str
            The id of the conversation you're taking the action on.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConversationResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.conversations.get(
                conversation_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(conversation_id, request_options=request_options)
        return _response.data

    async def delete(
        self, conversation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a particular conversation

        Parameters
        ----------
        conversation_id : str
            The id of the conversation you're taking the action on.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.conversations.delete(
                conversation_id="21m00Tcm4TlvDq8ikWAM",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(conversation_id, request_options=request_options)
        return _response.data

    @property
    def audio(self):
        if self._audio is None:
            from .audio.client import AsyncAudioClient  # noqa: E402

            self._audio = AsyncAudioClient(client_wrapper=self._client_wrapper)
        return self._audio

    @property
    def feedback(self):
        if self._feedback is None:
            from .feedback.client import AsyncFeedbackClient  # noqa: E402

            self._feedback = AsyncFeedbackClient(client_wrapper=self._client_wrapper)
        return self._feedback
