# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.mcp_server_config_input import McpServerConfigInput
from ...types.mcp_server_response_model import McpServerResponseModel
from ...types.mcp_servers_response_model import McpServersResponseModel
from .raw_client import AsyncRawMcpServersClient, RawMcpServersClient

if typing.TYPE_CHECKING:
    from .approval_policy.client import ApprovalPolicyClient, AsyncApprovalPolicyClient
    from .tool_approvals.client import AsyncToolApprovalsClient, ToolApprovalsClient
    from .tools.client import AsyncToolsClient, ToolsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class McpServersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMcpServersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._tools: typing.Optional[ToolsClient] = None
        self._approval_policy: typing.Optional[ApprovalPolicyClient] = None
        self._tool_approvals: typing.Optional[ToolApprovalsClient] = None

    @property
    def with_raw_response(self) -> RawMcpServersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMcpServersClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> McpServersResponseModel:
        """
        Retrieve all MCP server configurations available in the workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServersResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.mcp_servers.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self, *, config: McpServerConfigInput, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponseModel:
        """
        Create a new MCP server configuration in the workspace.

        Parameters
        ----------
        config : McpServerConfigInput
            Configuration details for the MCP Server.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs, McpServerConfigInput

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.mcp_servers.create(
            config=McpServerConfigInput(
                url="url",
                name="name",
            ),
        )
        """
        _response = self._raw_client.create(config=config, request_options=request_options)
        return _response.data

    def get(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponseModel:
        """
        Retrieve a specific MCP server configuration from the workspace.

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP Server.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.mcp_servers.get(
            mcp_server_id="mcp_server_id",
        )
        """
        _response = self._raw_client.get(mcp_server_id, request_options=request_options)
        return _response.data

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import ToolsClient  # noqa: E402

            self._tools = ToolsClient(client_wrapper=self._client_wrapper)
        return self._tools

    @property
    def approval_policy(self):
        if self._approval_policy is None:
            from .approval_policy.client import ApprovalPolicyClient  # noqa: E402

            self._approval_policy = ApprovalPolicyClient(client_wrapper=self._client_wrapper)
        return self._approval_policy

    @property
    def tool_approvals(self):
        if self._tool_approvals is None:
            from .tool_approvals.client import ToolApprovalsClient  # noqa: E402

            self._tool_approvals = ToolApprovalsClient(client_wrapper=self._client_wrapper)
        return self._tool_approvals


class AsyncMcpServersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMcpServersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._tools: typing.Optional[AsyncToolsClient] = None
        self._approval_policy: typing.Optional[AsyncApprovalPolicyClient] = None
        self._tool_approvals: typing.Optional[AsyncToolApprovalsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawMcpServersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMcpServersClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> McpServersResponseModel:
        """
        Retrieve all MCP server configurations available in the workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServersResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.mcp_servers.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self, *, config: McpServerConfigInput, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponseModel:
        """
        Create a new MCP server configuration in the workspace.

        Parameters
        ----------
        config : McpServerConfigInput
            Configuration details for the MCP Server.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs, McpServerConfigInput

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.mcp_servers.create(
                config=McpServerConfigInput(
                    url="url",
                    name="name",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(config=config, request_options=request_options)
        return _response.data

    async def get(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponseModel:
        """
        Retrieve a specific MCP server configuration from the workspace.

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP Server.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.mcp_servers.get(
                mcp_server_id="mcp_server_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(mcp_server_id, request_options=request_options)
        return _response.data

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import AsyncToolsClient  # noqa: E402

            self._tools = AsyncToolsClient(client_wrapper=self._client_wrapper)
        return self._tools

    @property
    def approval_policy(self):
        if self._approval_policy is None:
            from .approval_policy.client import AsyncApprovalPolicyClient  # noqa: E402

            self._approval_policy = AsyncApprovalPolicyClient(client_wrapper=self._client_wrapper)
        return self._approval_policy

    @property
    def tool_approvals(self):
        if self._tool_approvals is None:
            from .tool_approvals.client import AsyncToolApprovalsClient  # noqa: E402

            self._tool_approvals = AsyncToolApprovalsClient(client_wrapper=self._client_wrapper)
        return self._tool_approvals
