# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.adhoc_agent_config_override_for_test_request_model import AdhocAgentConfigOverrideForTestRequestModel
from ....types.get_test_suite_invocation_response_model import GetTestSuiteInvocationResponseModel
from .raw_client import AsyncRawInvocationsClient, RawInvocationsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InvocationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInvocationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInvocationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInvocationsClient
        """
        return self._raw_client

    def get(
        self, test_invocation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTestSuiteInvocationResponseModel:
        """
        Gets a test invocation by ID.

        Parameters
        ----------
        test_invocation_id : str
            The id of a test invocation. This is returned when tests are run.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTestSuiteInvocationResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.tests.invocations.get(
            test_invocation_id="test_invocation_id",
        )
        """
        _response = self._raw_client.get(test_invocation_id, request_options=request_options)
        return _response.data

    def resubmit(
        self,
        test_invocation_id: str,
        *,
        test_run_ids: typing.Sequence[str],
        agent_id: str,
        agent_config_override: typing.Optional[AdhocAgentConfigOverrideForTestRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Resubmits specific test runs from a test invocation.

        Parameters
        ----------
        test_invocation_id : str
            The id of a test invocation. This is returned when tests are run.

        test_run_ids : typing.Sequence[str]
            List of test run IDs to resubmit

        agent_id : str
            Agent ID to resubmit tests for

        agent_config_override : typing.Optional[AdhocAgentConfigOverrideForTestRequestModel]
            Configuration overrides to use for testing. If not provided, the agent's default configuration will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.conversational_ai.tests.invocations.resubmit(
            test_invocation_id="test_invocation_id",
            test_run_ids=["test_run_ids"],
            agent_id="agent_id",
        )
        """
        _response = self._raw_client.resubmit(
            test_invocation_id,
            test_run_ids=test_run_ids,
            agent_id=agent_id,
            agent_config_override=agent_config_override,
            request_options=request_options,
        )
        return _response.data


class AsyncInvocationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInvocationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInvocationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInvocationsClient
        """
        return self._raw_client

    async def get(
        self, test_invocation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTestSuiteInvocationResponseModel:
        """
        Gets a test invocation by ID.

        Parameters
        ----------
        test_invocation_id : str
            The id of a test invocation. This is returned when tests are run.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTestSuiteInvocationResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.tests.invocations.get(
                test_invocation_id="test_invocation_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(test_invocation_id, request_options=request_options)
        return _response.data

    async def resubmit(
        self,
        test_invocation_id: str,
        *,
        test_run_ids: typing.Sequence[str],
        agent_id: str,
        agent_config_override: typing.Optional[AdhocAgentConfigOverrideForTestRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Resubmits specific test runs from a test invocation.

        Parameters
        ----------
        test_invocation_id : str
            The id of a test invocation. This is returned when tests are run.

        test_run_ids : typing.Sequence[str]
            List of test run IDs to resubmit

        agent_id : str
            Agent ID to resubmit tests for

        agent_config_override : typing.Optional[AdhocAgentConfigOverrideForTestRequestModel]
            Configuration overrides to use for testing. If not provided, the agent's default configuration will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversational_ai.tests.invocations.resubmit(
                test_invocation_id="test_invocation_id",
                test_run_ids=["test_run_ids"],
                agent_id="agent_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.resubmit(
            test_invocation_id,
            test_run_ids=test_run_ids,
            agent_id=agent_id,
            agent_config_override=agent_config_override,
            request_options=request_options,
        )
        return _response.data
