# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .speech_to_text_chunk_response_model import SpeechToTextChunkResponseModel


class MultichannelSpeechToTextResponseModel(UncheckedBaseModel):
    """
    Response model for multichannel speech-to-text transcription.
    """

    transcripts: typing.List[SpeechToTextChunkResponseModel] = pydantic.Field()
    """
    List of transcripts, one for each audio channel. Each transcript contains the text and word-level details for its respective channel.
    """

    transcription_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The transcription ID of the response.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
