# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class VoicemailDetectionToolConfig(UncheckedBaseModel):
    """
    Allows the agent to detect when a voicemail system is encountered.

    This tool should be invoked by the LLM when it detects that the call has been
    answered by a voicemail system rather than a human. If a voicemail message
    is configured, it will be played; otherwise the call will end immediately.
    """

    voicemail_message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional message to leave on voicemail when detected. If not provided, the call will end immediately when voicemail is detected.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
