# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawSamplesClient, RawSamplesClient

if typing.TYPE_CHECKING:
    from .audio.client import AsyncAudioClient, AudioClient


class SamplesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSamplesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._audio: typing.Optional[AudioClient] = None

    @property
    def with_raw_response(self) -> RawSamplesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSamplesClient
        """
        return self._raw_client

    @property
    def audio(self):
        if self._audio is None:
            from .audio.client import AudioClient  # noqa: E402

            self._audio = AudioClient(client_wrapper=self._client_wrapper)
        return self._audio


class AsyncSamplesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSamplesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._audio: typing.Optional[AsyncAudioClient] = None

    @property
    def with_raw_response(self) -> AsyncRawSamplesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSamplesClient
        """
        return self._raw_client

    @property
    def audio(self):
        if self._audio is None:
            from .audio.client import AsyncAudioClient  # noqa: E402

            self._audio = AsyncAudioClient(client_wrapper=self._client_wrapper)
        return self._audio
