# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawWorkspaceClient, RawWorkspaceClient

if typing.TYPE_CHECKING:
    from .groups.client import AsyncGroupsClient, GroupsClient
    from .invites.client import AsyncInvitesClient, InvitesClient
    from .members.client import AsyncMembersClient, MembersClient
    from .resources.client import AsyncResourcesClient, ResourcesClient


class WorkspaceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkspaceClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._groups: typing.Optional[GroupsClient] = None
        self._invites: typing.Optional[InvitesClient] = None
        self._members: typing.Optional[MembersClient] = None
        self._resources: typing.Optional[ResourcesClient] = None

    @property
    def with_raw_response(self) -> RawWorkspaceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkspaceClient
        """
        return self._raw_client

    @property
    def groups(self):
        if self._groups is None:
            from .groups.client import GroupsClient  # noqa: E402

            self._groups = GroupsClient(client_wrapper=self._client_wrapper)
        return self._groups

    @property
    def invites(self):
        if self._invites is None:
            from .invites.client import InvitesClient  # noqa: E402

            self._invites = InvitesClient(client_wrapper=self._client_wrapper)
        return self._invites

    @property
    def members(self):
        if self._members is None:
            from .members.client import MembersClient  # noqa: E402

            self._members = MembersClient(client_wrapper=self._client_wrapper)
        return self._members

    @property
    def resources(self):
        if self._resources is None:
            from .resources.client import ResourcesClient  # noqa: E402

            self._resources = ResourcesClient(client_wrapper=self._client_wrapper)
        return self._resources


class AsyncWorkspaceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkspaceClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._groups: typing.Optional[AsyncGroupsClient] = None
        self._invites: typing.Optional[AsyncInvitesClient] = None
        self._members: typing.Optional[AsyncMembersClient] = None
        self._resources: typing.Optional[AsyncResourcesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawWorkspaceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkspaceClient
        """
        return self._raw_client

    @property
    def groups(self):
        if self._groups is None:
            from .groups.client import AsyncGroupsClient  # noqa: E402

            self._groups = AsyncGroupsClient(client_wrapper=self._client_wrapper)
        return self._groups

    @property
    def invites(self):
        if self._invites is None:
            from .invites.client import AsyncInvitesClient  # noqa: E402

            self._invites = AsyncInvitesClient(client_wrapper=self._client_wrapper)
        return self._invites

    @property
    def members(self):
        if self._members is None:
            from .members.client import AsyncMembersClient  # noqa: E402

            self._members = AsyncMembersClient(client_wrapper=self._client_wrapper)
        return self._members

    @property
    def resources(self):
        if self._resources is None:
            from .resources.client import AsyncResourcesClient  # noqa: E402

            self._resources = AsyncResourcesClient(client_wrapper=self._client_wrapper)
        return self._resources
