import datetime

from google.protobuf import struct_pb2 as _struct_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class NodeKind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    NODE_KIND_UNSPECIFIED: _ClassVar[NodeKind]
    NODE_KIND_AGENT: _ClassVar[NodeKind]
    NODE_KIND_TOOL: _ClassVar[NodeKind]
    NODE_KIND_CHAIN: _ClassVar[NodeKind]
    NODE_KIND_LLM: _ClassVar[NodeKind]
    NODE_KIND_MEMORY: _ClassVar[NodeKind]
    NODE_KIND_RETRIEVER: _ClassVar[NodeKind]

class PropertyType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    PROPERTY_TYPE_UNSPECIFIED: _ClassVar[PropertyType]
    PROPERTY_TYPE_STRING: _ClassVar[PropertyType]
    PROPERTY_TYPE_TEXT: _ClassVar[PropertyType]
    PROPERTY_TYPE_NUMBER: _ClassVar[PropertyType]
    PROPERTY_TYPE_BOOLEAN: _ClassVar[PropertyType]
    PROPERTY_TYPE_OPTIONS: _ClassVar[PropertyType]
    PROPERTY_TYPE_COLLECTION: _ClassVar[PropertyType]
    PROPERTY_TYPE_FIXED_COLLECTION: _ClassVar[PropertyType]
    PROPERTY_TYPE_JSON: _ClassVar[PropertyType]
    PROPERTY_TYPE_NOTICE: _ClassVar[PropertyType]
    PROPERTY_TYPE_CALLOUT: _ClassVar[PropertyType]
    PROPERTY_TYPE_CREDENTIAL: _ClassVar[PropertyType]
    PROPERTY_TYPE_RESOURCE_LOCATOR: _ClassVar[PropertyType]
    PROPERTY_TYPE_CUSTOM: _ClassVar[PropertyType]

class ConnectionKind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    CONNECTION_KIND_UNSPECIFIED: _ClassVar[ConnectionKind]
    CONNECTION_KIND_MAIN: _ClassVar[ConnectionKind]
    CONNECTION_KIND_AI_TOOL: _ClassVar[ConnectionKind]
    CONNECTION_KIND_AI_LANGUAGE_MODEL: _ClassVar[ConnectionKind]
    CONNECTION_KIND_AI_OUTPUT_PARSER: _ClassVar[ConnectionKind]
    CONNECTION_KIND_AI_MEMORY: _ClassVar[ConnectionKind]
NODE_KIND_UNSPECIFIED: NodeKind
NODE_KIND_AGENT: NodeKind
NODE_KIND_TOOL: NodeKind
NODE_KIND_CHAIN: NodeKind
NODE_KIND_LLM: NodeKind
NODE_KIND_MEMORY: NodeKind
NODE_KIND_RETRIEVER: NodeKind
PROPERTY_TYPE_UNSPECIFIED: PropertyType
PROPERTY_TYPE_STRING: PropertyType
PROPERTY_TYPE_TEXT: PropertyType
PROPERTY_TYPE_NUMBER: PropertyType
PROPERTY_TYPE_BOOLEAN: PropertyType
PROPERTY_TYPE_OPTIONS: PropertyType
PROPERTY_TYPE_COLLECTION: PropertyType
PROPERTY_TYPE_FIXED_COLLECTION: PropertyType
PROPERTY_TYPE_JSON: PropertyType
PROPERTY_TYPE_NOTICE: PropertyType
PROPERTY_TYPE_CALLOUT: PropertyType
PROPERTY_TYPE_CREDENTIAL: PropertyType
PROPERTY_TYPE_RESOURCE_LOCATOR: PropertyType
PROPERTY_TYPE_CUSTOM: PropertyType
CONNECTION_KIND_UNSPECIFIED: ConnectionKind
CONNECTION_KIND_MAIN: ConnectionKind
CONNECTION_KIND_AI_TOOL: ConnectionKind
CONNECTION_KIND_AI_LANGUAGE_MODEL: ConnectionKind
CONNECTION_KIND_AI_OUTPUT_PARSER: ConnectionKind
CONNECTION_KIND_AI_MEMORY: ConnectionKind

class PropertyOption(_message.Message):
    __slots__ = ()
    NAME_FIELD_NUMBER: _ClassVar[int]
    VALUE_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    name: str
    value: str
    description: str
    def __init__(self, name: _Optional[str] = ..., value: _Optional[str] = ..., description: _Optional[str] = ...) -> None: ...

class StringList(_message.Message):
    __slots__ = ()
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, values: _Optional[_Iterable[str]] = ...) -> None: ...

class DisplayOptions(_message.Message):
    __slots__ = ()
    class ShowEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: StringList
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[StringList, _Mapping]] = ...) -> None: ...
    class HideEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: StringList
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[StringList, _Mapping]] = ...) -> None: ...
    class EqualsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: StringList
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[StringList, _Mapping]] = ...) -> None: ...
    SHOW_FIELD_NUMBER: _ClassVar[int]
    HIDE_FIELD_NUMBER: _ClassVar[int]
    EQUALS_FIELD_NUMBER: _ClassVar[int]
    EXPRESSION_FIELD_NUMBER: _ClassVar[int]
    show: _containers.MessageMap[str, StringList]
    hide: _containers.MessageMap[str, StringList]
    equals: _containers.MessageMap[str, StringList]
    expression: str
    def __init__(self, show: _Optional[_Mapping[str, StringList]] = ..., hide: _Optional[_Mapping[str, StringList]] = ..., equals: _Optional[_Mapping[str, StringList]] = ..., expression: _Optional[str] = ...) -> None: ...

class CredentialBinding(_message.Message):
    __slots__ = ()
    CREDENTIAL_URN_FIELD_NUMBER: _ClassVar[int]
    CREDENTIAL_TYPE_FIELD_NUMBER: _ClassVar[int]
    SCOPES_FIELD_NUMBER: _ClassVar[int]
    credential_urn: str
    credential_type: str
    scopes: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, credential_urn: _Optional[str] = ..., credential_type: _Optional[str] = ..., scopes: _Optional[_Iterable[str]] = ...) -> None: ...

class PropertySchema(_message.Message):
    __slots__ = ()
    class TypeOptionsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    NAME_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    TYPE_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_VALUE_FIELD_NUMBER: _ClassVar[int]
    OPTIONS_FIELD_NUMBER: _ClassVar[int]
    CHILDREN_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_OPTIONS_FIELD_NUMBER: _ClassVar[int]
    TYPE_OPTIONS_FIELD_NUMBER: _ClassVar[int]
    REQUIRED_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    PLACEHOLDER_FIELD_NUMBER: _ClassVar[int]
    HINT_MARKDOWN_FIELD_NUMBER: _ClassVar[int]
    NO_DATA_EXPRESSION_FIELD_NUMBER: _ClassVar[int]
    SHARED_BUNDLE_IDS_FIELD_NUMBER: _ClassVar[int]
    CUSTOM_TYPE_FIELD_NUMBER: _ClassVar[int]
    CREDENTIAL_FIELD_NUMBER: _ClassVar[int]
    name: str
    display_name: str
    type: PropertyType
    default_value: _struct_pb2.Value
    options: _containers.RepeatedCompositeFieldContainer[PropertyOption]
    children: _containers.RepeatedCompositeFieldContainer[PropertySchema]
    display_options: DisplayOptions
    type_options: _containers.MessageMap[str, _struct_pb2.Value]
    required: bool
    description: str
    placeholder: str
    hint_markdown: str
    no_data_expression: bool
    shared_bundle_ids: _containers.RepeatedScalarFieldContainer[str]
    custom_type: str
    credential: CredentialBinding
    def __init__(self, name: _Optional[str] = ..., display_name: _Optional[str] = ..., type: _Optional[_Union[PropertyType, str]] = ..., default_value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ..., options: _Optional[_Iterable[_Union[PropertyOption, _Mapping]]] = ..., children: _Optional[_Iterable[_Union[PropertySchema, _Mapping]]] = ..., display_options: _Optional[_Union[DisplayOptions, _Mapping]] = ..., type_options: _Optional[_Mapping[str, _struct_pb2.Value]] = ..., required: _Optional[bool] = ..., description: _Optional[str] = ..., placeholder: _Optional[str] = ..., hint_markdown: _Optional[str] = ..., no_data_expression: _Optional[bool] = ..., shared_bundle_ids: _Optional[_Iterable[str]] = ..., custom_type: _Optional[str] = ..., credential: _Optional[_Union[CredentialBinding, _Mapping]] = ...) -> None: ...

class DocumentationLinks(_message.Message):
    __slots__ = ()
    URLS_FIELD_NUMBER: _ClassVar[int]
    urls: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, urls: _Optional[_Iterable[str]] = ...) -> None: ...

class CatalogMetadata(_message.Message):
    __slots__ = ()
    class DocumentationEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: DocumentationLinks
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[DocumentationLinks, _Mapping]] = ...) -> None: ...
    ICON_FIELD_NUMBER: _ClassVar[int]
    ICON_COLOR_FIELD_NUMBER: _ClassVar[int]
    ALIAS_FIELD_NUMBER: _ClassVar[int]
    CATEGORIES_FIELD_NUMBER: _ClassVar[int]
    DOCUMENTATION_FIELD_NUMBER: _ClassVar[int]
    icon: str
    icon_color: str
    alias: _containers.RepeatedScalarFieldContainer[str]
    categories: _containers.RepeatedScalarFieldContainer[str]
    documentation: _containers.MessageMap[str, DocumentationLinks]
    def __init__(self, icon: _Optional[str] = ..., icon_color: _Optional[str] = ..., alias: _Optional[_Iterable[str]] = ..., categories: _Optional[_Iterable[str]] = ..., documentation: _Optional[_Mapping[str, DocumentationLinks]] = ...) -> None: ...

class NodeInput(_message.Message):
    __slots__ = ()
    KIND_FIELD_NUMBER: _ClassVar[int]
    EXPRESSION_FIELD_NUMBER: _ClassVar[int]
    kind: ConnectionKind
    expression: str
    def __init__(self, kind: _Optional[_Union[ConnectionKind, str]] = ..., expression: _Optional[str] = ...) -> None: ...

class NodeOutput(_message.Message):
    __slots__ = ()
    KIND_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    kind: ConnectionKind
    name: str
    def __init__(self, kind: _Optional[_Union[ConnectionKind, str]] = ..., name: _Optional[str] = ...) -> None: ...

class NodeHint(_message.Message):
    __slots__ = ()
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    TYPE_FIELD_NUMBER: _ClassVar[int]
    LOCATION_FIELD_NUMBER: _ClassVar[int]
    WHEN_EXPRESSION_FIELD_NUMBER: _ClassVar[int]
    message: str
    type: str
    location: str
    when_expression: str
    def __init__(self, message: _Optional[str] = ..., type: _Optional[str] = ..., location: _Optional[str] = ..., when_expression: _Optional[str] = ...) -> None: ...

class NodeVersion(_message.Message):
    __slots__ = ()
    class DefaultsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    class RuntimeConfigEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    VERSION_FIELD_NUMBER: _ClassVar[int]
    KIND_FIELD_NUMBER: _ClassVar[int]
    CATALOG_FIELD_NUMBER: _ClassVar[int]
    PROPERTIES_FIELD_NUMBER: _ClassVar[int]
    DEFAULTS_FIELD_NUMBER: _ClassVar[int]
    RUNTIME_CONFIG_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    CHANGE_LOG_MARKDOWN_FIELD_NUMBER: _ClassVar[int]
    INPUTS_FIELD_NUMBER: _ClassVar[int]
    OUTPUTS_FIELD_NUMBER: _ClassVar[int]
    GROUPS_FIELD_NUMBER: _ClassVar[int]
    HINTS_FIELD_NUMBER: _ClassVar[int]
    version: str
    kind: NodeKind
    catalog: CatalogMetadata
    properties: _containers.RepeatedCompositeFieldContainer[PropertySchema]
    defaults: _containers.MessageMap[str, _struct_pb2.Value]
    runtime_config: _containers.MessageMap[str, _struct_pb2.Value]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    change_log_markdown: str
    inputs: _containers.RepeatedCompositeFieldContainer[NodeInput]
    outputs: _containers.RepeatedCompositeFieldContainer[NodeOutput]
    groups: _containers.RepeatedScalarFieldContainer[str]
    hints: _containers.RepeatedCompositeFieldContainer[NodeHint]
    def __init__(self, version: _Optional[str] = ..., kind: _Optional[_Union[NodeKind, str]] = ..., catalog: _Optional[_Union[CatalogMetadata, _Mapping]] = ..., properties: _Optional[_Iterable[_Union[PropertySchema, _Mapping]]] = ..., defaults: _Optional[_Mapping[str, _struct_pb2.Value]] = ..., runtime_config: _Optional[_Mapping[str, _struct_pb2.Value]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ..., change_log_markdown: _Optional[str] = ..., inputs: _Optional[_Iterable[_Union[NodeInput, _Mapping]]] = ..., outputs: _Optional[_Iterable[_Union[NodeOutput, _Mapping]]] = ..., groups: _Optional[_Iterable[str]] = ..., hints: _Optional[_Iterable[_Union[NodeHint, _Mapping]]] = ...) -> None: ...

class NodeDefinition(_message.Message):
    __slots__ = ()
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    VERSIONS_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_VERSION_FIELD_NUMBER: _ClassVar[int]
    node_id: str
    display_name: str
    description: str
    versions: _containers.RepeatedCompositeFieldContainer[NodeVersion]
    default_version: str
    def __init__(self, node_id: _Optional[str] = ..., display_name: _Optional[str] = ..., description: _Optional[str] = ..., versions: _Optional[_Iterable[_Union[NodeVersion, _Mapping]]] = ..., default_version: _Optional[str] = ...) -> None: ...

class ToolInstance(_message.Message):
    __slots__ = ()
    class ParametersEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    TOOL_NODE_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    PARAMETERS_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    tool_node_id: str
    version: str
    parameters: _containers.MessageMap[str, _struct_pb2.Value]
    metadata: _containers.MessageMap[str, _struct_pb2.Value]
    def __init__(self, tool_node_id: _Optional[str] = ..., version: _Optional[str] = ..., parameters: _Optional[_Mapping[str, _struct_pb2.Value]] = ..., metadata: _Optional[_Mapping[str, _struct_pb2.Value]] = ...) -> None: ...

class RoutingCondition(_message.Message):
    __slots__ = ()
    class CustomMetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    UI_PAGE_FIELD_NUMBER: _ClassVar[int]
    USER_ROLE_FIELD_NUMBER: _ClassVar[int]
    REQUIRES_GRAPH_FIELD_NUMBER: _ClassVar[int]
    REQUIRES_SELECTION_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_KIND_FIELD_NUMBER: _ClassVar[int]
    CUSTOM_METADATA_FIELD_NUMBER: _ClassVar[int]
    ui_page: str
    user_role: str
    requires_graph: bool
    requires_selection: bool
    element_kind: str
    custom_metadata: _containers.ScalarMap[str, str]
    def __init__(self, ui_page: _Optional[str] = ..., user_role: _Optional[str] = ..., requires_graph: _Optional[bool] = ..., requires_selection: _Optional[bool] = ..., element_kind: _Optional[str] = ..., custom_metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class RoutingRule(_message.Message):
    __slots__ = ()
    RULE_ID_FIELD_NUMBER: _ClassVar[int]
    PRIORITY_FIELD_NUMBER: _ClassVar[int]
    CONDITION_FIELD_NUMBER: _ClassVar[int]
    AGENT_INSTANCE_ID_FIELD_NUMBER: _ClassVar[int]
    rule_id: str
    priority: int
    condition: RoutingCondition
    agent_instance_id: str
    def __init__(self, rule_id: _Optional[str] = ..., priority: _Optional[int] = ..., condition: _Optional[_Union[RoutingCondition, _Mapping]] = ..., agent_instance_id: _Optional[str] = ...) -> None: ...

class AgentInstance(_message.Message):
    __slots__ = ()
    class ParametersEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    class RuntimeOverridesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: _struct_pb2.Value
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[_struct_pb2.Value, _Mapping]] = ...) -> None: ...
    AGENT_INSTANCE_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    PARAMETERS_FIELD_NUMBER: _ClassVar[int]
    TOOLS_FIELD_NUMBER: _ClassVar[int]
    RUNTIME_OVERRIDES_FIELD_NUMBER: _ClassVar[int]
    PUBLISHED_AT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    ALLOWED_ROLES_FIELD_NUMBER: _ClassVar[int]
    UI_PAGES_FIELD_NUMBER: _ClassVar[int]
    ROUTING_RULES_FIELD_NUMBER: _ClassVar[int]
    COMPILED_ARTIFACT_URI_FIELD_NUMBER: _ClassVar[int]
    COMPILED_ARTIFACT_HASH_FIELD_NUMBER: _ClassVar[int]
    COMPILED_AT_FIELD_NUMBER: _ClassVar[int]
    agent_instance_id: str
    node_id: str
    version: str
    parameters: _containers.MessageMap[str, _struct_pb2.Value]
    tools: _containers.RepeatedCompositeFieldContainer[ToolInstance]
    runtime_overrides: _containers.MessageMap[str, _struct_pb2.Value]
    published_at: _timestamp_pb2.Timestamp
    tenant_id: str
    name: str
    description: str
    allowed_roles: _containers.RepeatedScalarFieldContainer[str]
    ui_pages: _containers.RepeatedScalarFieldContainer[str]
    routing_rules: _containers.RepeatedCompositeFieldContainer[RoutingRule]
    compiled_artifact_uri: str
    compiled_artifact_hash: str
    compiled_at: _timestamp_pb2.Timestamp
    def __init__(self, agent_instance_id: _Optional[str] = ..., node_id: _Optional[str] = ..., version: _Optional[str] = ..., parameters: _Optional[_Mapping[str, _struct_pb2.Value]] = ..., tools: _Optional[_Iterable[_Union[ToolInstance, _Mapping]]] = ..., runtime_overrides: _Optional[_Mapping[str, _struct_pb2.Value]] = ..., published_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., tenant_id: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., allowed_roles: _Optional[_Iterable[str]] = ..., ui_pages: _Optional[_Iterable[str]] = ..., routing_rules: _Optional[_Iterable[_Union[RoutingRule, _Mapping]]] = ..., compiled_artifact_uri: _Optional[str] = ..., compiled_artifact_hash: _Optional[str] = ..., compiled_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class ListNodesRequest(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class ListNodesResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[NodeDefinition]
    def __init__(self, nodes: _Optional[_Iterable[_Union[NodeDefinition, _Mapping]]] = ...) -> None: ...

class StreamCatalogRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    def __init__(self, tenant_id: _Optional[str] = ...) -> None: ...

class StreamCatalogResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    AGENTS_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[NodeDefinition]
    agents: _containers.RepeatedCompositeFieldContainer[AgentInstance]
    updated_at: _timestamp_pb2.Timestamp
    def __init__(self, nodes: _Optional[_Iterable[_Union[NodeDefinition, _Mapping]]] = ..., agents: _Optional[_Iterable[_Union[AgentInstance, _Mapping]]] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class ListAgentsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    def __init__(self, tenant_id: _Optional[str] = ...) -> None: ...

class ListAgentsResponse(_message.Message):
    __slots__ = ()
    AGENTS_FIELD_NUMBER: _ClassVar[int]
    agents: _containers.RepeatedCompositeFieldContainer[AgentInstance]
    def __init__(self, agents: _Optional[_Iterable[_Union[AgentInstance, _Mapping]]] = ...) -> None: ...

class CreateAgentRequest(_message.Message):
    __slots__ = ()
    AGENT_FIELD_NUMBER: _ClassVar[int]
    agent: AgentInstance
    def __init__(self, agent: _Optional[_Union[AgentInstance, _Mapping]] = ...) -> None: ...

class CreateAgentResponse(_message.Message):
    __slots__ = ()
    AGENT_FIELD_NUMBER: _ClassVar[int]
    agent: AgentInstance
    def __init__(self, agent: _Optional[_Union[AgentInstance, _Mapping]] = ...) -> None: ...

class UpdateAgentRequest(_message.Message):
    __slots__ = ()
    AGENT_FIELD_NUMBER: _ClassVar[int]
    agent: AgentInstance
    def __init__(self, agent: _Optional[_Union[AgentInstance, _Mapping]] = ...) -> None: ...

class UpdateAgentResponse(_message.Message):
    __slots__ = ()
    AGENT_FIELD_NUMBER: _ClassVar[int]
    agent: AgentInstance
    def __init__(self, agent: _Optional[_Union[AgentInstance, _Mapping]] = ...) -> None: ...

class PublishAgentRequest(_message.Message):
    __slots__ = ()
    AGENT_INSTANCE_ID_FIELD_NUMBER: _ClassVar[int]
    agent_instance_id: str
    def __init__(self, agent_instance_id: _Optional[str] = ...) -> None: ...

class PublishAgentResponse(_message.Message):
    __slots__ = ()
    AGENT_FIELD_NUMBER: _ClassVar[int]
    agent: AgentInstance
    def __init__(self, agent: _Optional[_Union[AgentInstance, _Mapping]] = ...) -> None: ...

class SimulateRouteRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    CONDITION_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    condition: RoutingCondition
    def __init__(self, tenant_id: _Optional[str] = ..., condition: _Optional[_Union[RoutingCondition, _Mapping]] = ...) -> None: ...

class SimulateRouteResponse(_message.Message):
    __slots__ = ()
    MATCHED_RULE_FIELD_NUMBER: _ClassVar[int]
    AGENT_FIELD_NUMBER: _ClassVar[int]
    matched_rule: RoutingRule
    agent: AgentInstance
    def __init__(self, matched_rule: _Optional[_Union[RoutingRule, _Mapping]] = ..., agent: _Optional[_Union[AgentInstance, _Mapping]] = ...) -> None: ...
