from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.graph.v1 import graph_pb2 as _graph_pb2
from buf.validate import validate_pb2 as _validate_pb2
from google.protobuf import field_mask_pb2 as _field_mask_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class CreateRepositoryRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository: _graph_pb2.Repository
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ...) -> None: ...

class CreateRepositoryResponse(_message.Message):
    __slots__ = ()
    REPOSITORY_FIELD_NUMBER: _ClassVar[int]
    repository: _graph_pb2.Repository
    def __init__(self, repository: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ...) -> None: ...

class UpdateRepositoryRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository: _graph_pb2.Repository
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateRepositoryResponse(_message.Message):
    __slots__ = ()
    REPOSITORY_FIELD_NUMBER: _ClassVar[int]
    repository: _graph_pb2.Repository
    def __init__(self, repository: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ...) -> None: ...

class DeleteRepositoryRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ...) -> None: ...

class DeleteRepositoryResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetRepositoryRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ...) -> None: ...

class GetRepositoryResponse(_message.Message):
    __slots__ = ()
    REPOSITORY_FIELD_NUMBER: _ClassVar[int]
    repository: _graph_pb2.Repository
    def __init__(self, repository: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ...) -> None: ...

class ListRepositoriesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    tenant_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., tenant_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListRepositoriesResponse(_message.Message):
    __slots__ = ()
    REPOSITORIES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    repositories: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Repository]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, repositories: _Optional[_Iterable[_Union[_graph_pb2.Repository, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class CreateNodeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    NODE_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    node: _graph_pb2.Node
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., node: _Optional[_Union[_graph_pb2.Node, _Mapping]] = ...) -> None: ...

class CreateNodeResponse(_message.Message):
    __slots__ = ()
    NODE_FIELD_NUMBER: _ClassVar[int]
    node: _graph_pb2.Node
    def __init__(self, node: _Optional[_Union[_graph_pb2.Node, _Mapping]] = ...) -> None: ...

class UpdateNodeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    NODE_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    node: _graph_pb2.Node
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., node: _Optional[_Union[_graph_pb2.Node, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateNodeResponse(_message.Message):
    __slots__ = ()
    NODE_FIELD_NUMBER: _ClassVar[int]
    node: _graph_pb2.Node
    def __init__(self, node: _Optional[_Union[_graph_pb2.Node, _Mapping]] = ...) -> None: ...

class MoveNodeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    NEW_PARENT_ID_FIELD_NUMBER: _ClassVar[int]
    NEW_ORDER_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    node_id: str
    new_parent_id: str
    new_order: int
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., node_id: _Optional[str] = ..., new_parent_id: _Optional[str] = ..., new_order: _Optional[int] = ...) -> None: ...

class MoveNodeResponse(_message.Message):
    __slots__ = ()
    NODE_FIELD_NUMBER: _ClassVar[int]
    node: _graph_pb2.Node
    def __init__(self, node: _Optional[_Union[_graph_pb2.Node, _Mapping]] = ...) -> None: ...

class DeleteNodeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    RECURSIVE_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    node_id: str
    recursive: bool
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., node_id: _Optional[str] = ..., recursive: _Optional[bool] = ...) -> None: ...

class DeleteNodeResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetTreeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ...) -> None: ...

class GetTreeResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Node]
    def __init__(self, nodes: _Optional[_Iterable[_Union[_graph_pb2.Node, _Mapping]]] = ...) -> None: ...

class ListChildrenRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    PARENT_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    parent_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., parent_id: _Optional[str] = ...) -> None: ...

class ListChildrenResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Node]
    def __init__(self, nodes: _Optional[_Iterable[_Union[_graph_pb2.Node, _Mapping]]] = ...) -> None: ...

class AssignElementRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ASSIGNMENT_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    assignment: _graph_pb2.Assignment
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., assignment: _Optional[_Union[_graph_pb2.Assignment, _Mapping]] = ...) -> None: ...

class AssignElementResponse(_message.Message):
    __slots__ = ()
    ASSIGNMENT_FIELD_NUMBER: _ClassVar[int]
    assignment: _graph_pb2.Assignment
    def __init__(self, assignment: _Optional[_Union[_graph_pb2.Assignment, _Mapping]] = ...) -> None: ...

class UnassignElementRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    ASSIGNMENT_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    node_id: str
    assignment_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., node_id: _Optional[str] = ..., assignment_id: _Optional[str] = ...) -> None: ...

class UnassignElementResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class ListNodeAssignmentsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    node_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., node_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListNodeAssignmentsResponse(_message.Message):
    __slots__ = ()
    ASSIGNMENTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    assignments: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Assignment]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, assignments: _Optional[_Iterable[_Union[_graph_pb2.Assignment, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class SearchNodesRequest(_message.Message):
    __slots__ = ()
    class FiltersEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    FILTERS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    filters: _containers.ScalarMap[str, str]
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., filters: _Optional[_Mapping[str, str]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class SearchNodesResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Node]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, nodes: _Optional[_Iterable[_Union[_graph_pb2.Node, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetRepositoryStatsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ...) -> None: ...

class GetRepositoryStatsResponse(_message.Message):
    __slots__ = ()
    STATS_FIELD_NUMBER: _ClassVar[int]
    stats: _graph_pb2.RepositoryStats
    def __init__(self, stats: _Optional[_Union[_graph_pb2.RepositoryStats, _Mapping]] = ...) -> None: ...

class ListRepositoryElementsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_IDS_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
    SEARCH_QUERY_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_TYPES_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    node_ids: _containers.RepeatedScalarFieldContainer[str]
    element_type: str
    search_query: str
    pagination: _common_pb2.PaginationRequest
    element_types: _containers.RepeatedScalarFieldContainer[str]
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., node_ids: _Optional[_Iterable[str]] = ..., element_type: _Optional[str] = ..., search_query: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ..., element_types: _Optional[_Iterable[str]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class ListRepositoryElementsResponse(_message.Message):
    __slots__ = ()
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    elements: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Element]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, elements: _Optional[_Iterable[_Union[_graph_pb2.Element, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class CreateElementRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    element: _graph_pb2.Element
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., element: _Optional[_Union[_graph_pb2.Element, _Mapping]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class CreateElementResponse(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: _graph_pb2.Element
    def __init__(self, element: _Optional[_Union[_graph_pb2.Element, _Mapping]] = ...) -> None: ...

class UpdateElementRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    element: _graph_pb2.Element
    update_mask: _field_mask_pb2.FieldMask
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., element: _Optional[_Union[_graph_pb2.Element, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class UpdateElementResponse(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: _graph_pb2.Element
    def __init__(self, element: _Optional[_Union[_graph_pb2.Element, _Mapping]] = ...) -> None: ...

class DeleteElementRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    element_id: str
    repository_id: str
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., element_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class DeleteElementResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetElementRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    element_id: str
    repository_id: str
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., element_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class GetElementResponse(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: _graph_pb2.Element
    def __init__(self, element: _Optional[_Union[_graph_pb2.Element, _Mapping]] = ...) -> None: ...

class ListElementsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_IDS_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEYS_FIELD_NUMBER: _ClassVar[int]
    TAGS_FIELD_NUMBER: _ClassVar[int]
    LIFECYCLE_STATES_FIELD_NUMBER: _ClassVar[int]
    SEARCH_QUERY_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    tenant_id: str
    organization_id: str
    element_ids: _containers.RepeatedScalarFieldContainer[str]
    type_keys: _containers.RepeatedScalarFieldContainer[str]
    tags: _containers.RepeatedScalarFieldContainer[str]
    lifecycle_states: _containers.RepeatedScalarFieldContainer[str]
    search_query: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ..., element_ids: _Optional[_Iterable[str]] = ..., type_keys: _Optional[_Iterable[str]] = ..., tags: _Optional[_Iterable[str]] = ..., lifecycle_states: _Optional[_Iterable[str]] = ..., search_query: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListElementsResponse(_message.Message):
    __slots__ = ()
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    elements: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Element]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, elements: _Optional[_Iterable[_Union[_graph_pb2.Element, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListElementVersionsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    element_id: str
    repository_id: str
    pagination: _common_pb2.PaginationRequest
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., element_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class ListElementVersionsResponse(_message.Message):
    __slots__ = ()
    VERSIONS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    versions: _containers.RepeatedCompositeFieldContainer[_graph_pb2.ElementVersion]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, versions: _Optional[_Iterable[_Union[_graph_pb2.ElementVersion, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetElementVersionRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_NUMBER_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    element_id: str
    version_id: str
    version_number: int
    repository_id: str
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., element_id: _Optional[str] = ..., version_id: _Optional[str] = ..., version_number: _Optional[int] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class GetElementVersionResponse(_message.Message):
    __slots__ = ()
    VERSION_FIELD_NUMBER: _ClassVar[int]
    version: _graph_pb2.ElementVersion
    def __init__(self, version: _Optional[_Union[_graph_pb2.ElementVersion, _Mapping]] = ...) -> None: ...

class CreateRelationshipRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    relationship: _graph_pb2.ElementRelationship
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., relationship: _Optional[_Union[_graph_pb2.ElementRelationship, _Mapping]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class CreateRelationshipResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    relationship: _graph_pb2.ElementRelationship
    def __init__(self, relationship: _Optional[_Union[_graph_pb2.ElementRelationship, _Mapping]] = ...) -> None: ...

class UpdateRelationshipRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    relationship: _graph_pb2.ElementRelationship
    update_mask: _field_mask_pb2.FieldMask
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., relationship: _Optional[_Union[_graph_pb2.ElementRelationship, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class UpdateRelationshipResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    relationship: _graph_pb2.ElementRelationship
    def __init__(self, relationship: _Optional[_Union[_graph_pb2.ElementRelationship, _Mapping]] = ...) -> None: ...

class DeleteRelationshipRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    relationship_id: str
    repository_id: str
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., relationship_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class DeleteRelationshipResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetRelationshipRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    relationship_id: str
    repository_id: str
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., relationship_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class GetRelationshipResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    relationship: _graph_pb2.ElementRelationship
    def __init__(self, relationship: _Optional[_Union[_graph_pb2.ElementRelationship, _Mapping]] = ...) -> None: ...

class ListRelationshipsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_IDS_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ELEMENT_IDS_FIELD_NUMBER: _ClassVar[int]
    TARGET_ELEMENT_IDS_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_KINDS_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEYS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    tenant_id: str
    organization_id: str
    relationship_ids: _containers.RepeatedScalarFieldContainer[str]
    source_element_ids: _containers.RepeatedScalarFieldContainer[str]
    target_element_ids: _containers.RepeatedScalarFieldContainer[str]
    relationship_kinds: _containers.RepeatedScalarFieldContainer[str]
    type_keys: _containers.RepeatedScalarFieldContainer[str]
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ..., relationship_ids: _Optional[_Iterable[str]] = ..., source_element_ids: _Optional[_Iterable[str]] = ..., target_element_ids: _Optional[_Iterable[str]] = ..., relationship_kinds: _Optional[_Iterable[str]] = ..., type_keys: _Optional[_Iterable[str]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListRelationshipsResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIPS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    relationships: _containers.RepeatedCompositeFieldContainer[_graph_pb2.ElementRelationship]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, relationships: _Optional[_Iterable[_Union[_graph_pb2.ElementRelationship, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetElementNeighborhoodRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    DEPTH_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_KINDS_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_TYPE_KEYS_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    repository_id: str
    element_id: str
    depth: int
    relationship_kinds: _containers.RepeatedScalarFieldContainer[str]
    relationship_type_keys: _containers.RepeatedScalarFieldContainer[str]
    tenant_id: str
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., repository_id: _Optional[str] = ..., element_id: _Optional[str] = ..., depth: _Optional[int] = ..., relationship_kinds: _Optional[_Iterable[str]] = ..., relationship_type_keys: _Optional[_Iterable[str]] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ...) -> None: ...

class GetElementNeighborhoodResponse(_message.Message):
    __slots__ = ()
    CENTER_FIELD_NUMBER: _ClassVar[int]
    ADJACENT_ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIPS_FIELD_NUMBER: _ClassVar[int]
    center: _graph_pb2.Element
    adjacent_elements: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Element]
    relationships: _containers.RepeatedCompositeFieldContainer[_graph_pb2.ElementRelationship]
    def __init__(self, center: _Optional[_Union[_graph_pb2.Element, _Mapping]] = ..., adjacent_elements: _Optional[_Iterable[_Union[_graph_pb2.Element, _Mapping]]] = ..., relationships: _Optional[_Iterable[_Union[_graph_pb2.ElementRelationship, _Mapping]]] = ...) -> None: ...
