import datetime

from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from google.protobuf import any_pb2 as _any_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class InitiativeStage(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    INITIATIVE_STAGE_UNSPECIFIED: _ClassVar[InitiativeStage]
    INITIATIVE_STAGE_DISCOVER: _ClassVar[InitiativeStage]
    INITIATIVE_STAGE_ARCHITECT: _ClassVar[InitiativeStage]
    INITIATIVE_STAGE_BUILD: _ClassVar[InitiativeStage]
    INITIATIVE_STAGE_MEASURE: _ClassVar[InitiativeStage]
    INITIATIVE_STAGE_OPERATE: _ClassVar[InitiativeStage]

class InitiativeHealth(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    INITIATIVE_HEALTH_UNSPECIFIED: _ClassVar[InitiativeHealth]
    INITIATIVE_HEALTH_GREEN: _ClassVar[InitiativeHealth]
    INITIATIVE_HEALTH_AMBER: _ClassVar[InitiativeHealth]
    INITIATIVE_HEALTH_RED: _ClassVar[InitiativeHealth]

class InitiativeCadence(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    INITIATIVE_CADENCE_UNSPECIFIED: _ClassVar[InitiativeCadence]
    INITIATIVE_CADENCE_ADM: _ClassVar[InitiativeCadence]
    INITIATIVE_CADENCE_AGILE: _ClassVar[InitiativeCadence]
    INITIATIVE_CADENCE_HYBRID: _ClassVar[InitiativeCadence]
INITIATIVE_STAGE_UNSPECIFIED: InitiativeStage
INITIATIVE_STAGE_DISCOVER: InitiativeStage
INITIATIVE_STAGE_ARCHITECT: InitiativeStage
INITIATIVE_STAGE_BUILD: InitiativeStage
INITIATIVE_STAGE_MEASURE: InitiativeStage
INITIATIVE_STAGE_OPERATE: InitiativeStage
INITIATIVE_HEALTH_UNSPECIFIED: InitiativeHealth
INITIATIVE_HEALTH_GREEN: InitiativeHealth
INITIATIVE_HEALTH_AMBER: InitiativeHealth
INITIATIVE_HEALTH_RED: InitiativeHealth
INITIATIVE_CADENCE_UNSPECIFIED: InitiativeCadence
INITIATIVE_CADENCE_ADM: InitiativeCadence
INITIATIVE_CADENCE_AGILE: InitiativeCadence
INITIATIVE_CADENCE_HYBRID: InitiativeCadence

class Initiative(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    KEY_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    STAGE_FIELD_NUMBER: _ClassVar[int]
    HEALTH_FIELD_NUMBER: _ClassVar[int]
    CADENCE_FIELD_NUMBER: _ClassVar[int]
    SPONSOR_ID_FIELD_NUMBER: _ClassVar[int]
    PRODUCT_OWNER_ID_FIELD_NUMBER: _ClassVar[int]
    LEAD_ARCHITECT_ID_FIELD_NUMBER: _ClassVar[int]
    TIME_ZONE_FIELD_NUMBER: _ClassVar[int]
    LOCALE_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    repository_id: str
    key: str
    name: str
    description: str
    stage: InitiativeStage
    health: InitiativeHealth
    cadence: InitiativeCadence
    sponsor_id: str
    product_owner_id: str
    lead_architect_id: str
    time_zone: str
    locale: str
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., key: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., stage: _Optional[_Union[InitiativeStage, str]] = ..., health: _Optional[_Union[InitiativeHealth, str]] = ..., cadence: _Optional[_Union[InitiativeCadence, str]] = ..., sponsor_id: _Optional[str] = ..., product_owner_id: _Optional[str] = ..., lead_architect_id: _Optional[str] = ..., time_zone: _Optional[str] = ..., locale: _Optional[str] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class InitiativeMilestone(_message.Message):
    __slots__ = ()
    class ReadinessCriteriaEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    MILESTONE_TYPE_FIELD_NUMBER: _ClassVar[int]
    TARGET_DATE_FIELD_NUMBER: _ClassVar[int]
    ACTUAL_DATE_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    READINESS_CRITERIA_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    initiative_id: str
    milestone_type: str
    target_date: _timestamp_pb2.Timestamp
    actual_date: _timestamp_pb2.Timestamp
    status: str
    readiness_criteria: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., initiative_id: _Optional[str] = ..., milestone_type: _Optional[str] = ..., target_date: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., actual_date: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., status: _Optional[str] = ..., readiness_criteria: _Optional[_Mapping[str, str]] = ...) -> None: ...

class InitiativeWorkspaceNode(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    PARENT_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    SLUG_FIELD_NUMBER: _ClassVar[int]
    ORDER_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    IS_VIRTUAL_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    initiative_id: str
    node_id: str
    parent_id: str
    name: str
    slug: str
    order: int
    attributes: _containers.ScalarMap[str, str]
    is_virtual: bool
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., initiative_id: _Optional[str] = ..., node_id: _Optional[str] = ..., parent_id: _Optional[str] = ..., name: _Optional[str] = ..., slug: _Optional[str] = ..., order: _Optional[int] = ..., attributes: _Optional[_Mapping[str, str]] = ..., is_virtual: _Optional[bool] = ...) -> None: ...

class InitiativeMetricSnapshot(_message.Message):
    __slots__ = ()
    class AnomalyFlagsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    CAPTURED_AT_FIELD_NUMBER: _ClassVar[int]
    BOARD_METRICS_FIELD_NUMBER: _ClassVar[int]
    READINESS_METRICS_FIELD_NUMBER: _ClassVar[int]
    SCENARIO_METRICS_FIELD_NUMBER: _ClassVar[int]
    SLA_STATE_FIELD_NUMBER: _ClassVar[int]
    ANOMALY_FLAGS_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    initiative_id: str
    captured_at: _timestamp_pb2.Timestamp
    board_metrics: _any_pb2.Any
    readiness_metrics: _any_pb2.Any
    scenario_metrics: _any_pb2.Any
    sla_state: str
    anomaly_flags: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., initiative_id: _Optional[str] = ..., captured_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., board_metrics: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., readiness_metrics: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., scenario_metrics: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., sla_state: _Optional[str] = ..., anomaly_flags: _Optional[_Mapping[str, str]] = ...) -> None: ...

class InitiativeAlert(_message.Message):
    __slots__ = ()
    class ResolutionNotesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ENTITY_TYPE_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ENTITY_ID_FIELD_NUMBER: _ClassVar[int]
    ALERT_TYPE_FIELD_NUMBER: _ClassVar[int]
    SEVERITY_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    TRIGGERED_AT_FIELD_NUMBER: _ClassVar[int]
    ACKNOWLEDGED_AT_FIELD_NUMBER: _ClassVar[int]
    RESOLVED_AT_FIELD_NUMBER: _ClassVar[int]
    RESOLUTION_NOTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    initiative_id: str
    source_entity_type: str
    source_entity_id: str
    alert_type: str
    severity: str
    message: str
    triggered_at: _timestamp_pb2.Timestamp
    acknowledged_at: _timestamp_pb2.Timestamp
    resolved_at: _timestamp_pb2.Timestamp
    resolution_notes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., initiative_id: _Optional[str] = ..., source_entity_type: _Optional[str] = ..., source_entity_id: _Optional[str] = ..., alert_type: _Optional[str] = ..., severity: _Optional[str] = ..., message: _Optional[str] = ..., triggered_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., acknowledged_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., resolved_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., resolution_notes: _Optional[_Mapping[str, str]] = ...) -> None: ...
