import datetime

from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class InvitationStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    INVITATION_STATUS_UNSPECIFIED: _ClassVar[InvitationStatus]
    INVITATION_STATUS_PENDING: _ClassVar[InvitationStatus]
    INVITATION_STATUS_ACCEPTED: _ClassVar[InvitationStatus]
    INVITATION_STATUS_EXPIRED: _ClassVar[InvitationStatus]
    INVITATION_STATUS_REVOKED: _ClassVar[InvitationStatus]
INVITATION_STATUS_UNSPECIFIED: InvitationStatus
INVITATION_STATUS_PENDING: InvitationStatus
INVITATION_STATUS_ACCEPTED: InvitationStatus
INVITATION_STATUS_EXPIRED: InvitationStatus
INVITATION_STATUS_REVOKED: InvitationStatus

class Invitation(_message.Message):
    __slots__ = ()
    class MetadataAttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    EMAIL_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    INVITED_BY_USER_ID_FIELD_NUMBER: _ClassVar[int]
    INVITED_AT_FIELD_NUMBER: _ClassVar[int]
    ACCEPTED_AT_FIELD_NUMBER: _ClassVar[int]
    REVOKED_AT_FIELD_NUMBER: _ClassVar[int]
    EXPIRES_AT_FIELD_NUMBER: _ClassVar[int]
    TOKEN_HASH_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_NAME_FIELD_NUMBER: _ClassVar[int]
    INVITED_BY_NAME_FIELD_NUMBER: _ClassVar[int]
    METADATA_ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    email: str
    role: str
    status: InvitationStatus
    invited_by_user_id: str
    invited_at: _timestamp_pb2.Timestamp
    accepted_at: _timestamp_pb2.Timestamp
    revoked_at: _timestamp_pb2.Timestamp
    expires_at: _timestamp_pb2.Timestamp
    token_hash: str
    organization_name: str
    invited_by_name: str
    metadata_attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., email: _Optional[str] = ..., role: _Optional[str] = ..., status: _Optional[_Union[InvitationStatus, str]] = ..., invited_by_user_id: _Optional[str] = ..., invited_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., accepted_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., revoked_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., expires_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., token_hash: _Optional[str] = ..., organization_name: _Optional[str] = ..., invited_by_name: _Optional[str] = ..., metadata_attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class CreateInvitationRequest(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    EMAIL_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    EXPIRES_IN_DAYS_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    email: str
    role: str
    expires_in_days: int
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., email: _Optional[str] = ..., role: _Optional[str] = ..., expires_in_days: _Optional[int] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class CreateInvitationResponse(_message.Message):
    __slots__ = ()
    INVITATION_FIELD_NUMBER: _ClassVar[int]
    INVITATION_URL_FIELD_NUMBER: _ClassVar[int]
    TOKEN_FIELD_NUMBER: _ClassVar[int]
    invitation: Invitation
    invitation_url: str
    token: str
    def __init__(self, invitation: _Optional[_Union[Invitation, _Mapping]] = ..., invitation_url: _Optional[str] = ..., token: _Optional[str] = ...) -> None: ...

class ValidateInvitationRequest(_message.Message):
    __slots__ = ()
    TOKEN_FIELD_NUMBER: _ClassVar[int]
    token: str
    def __init__(self, token: _Optional[str] = ...) -> None: ...

class ValidateInvitationResponse(_message.Message):
    __slots__ = ()
    VALID_FIELD_NUMBER: _ClassVar[int]
    INVITATION_FIELD_NUMBER: _ClassVar[int]
    ERROR_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    valid: bool
    invitation: Invitation
    error_message: str
    def __init__(self, valid: _Optional[bool] = ..., invitation: _Optional[_Union[Invitation, _Mapping]] = ..., error_message: _Optional[str] = ...) -> None: ...

class AcceptInvitationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TOKEN_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    token: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., token: _Optional[str] = ...) -> None: ...

class AcceptInvitationResponse(_message.Message):
    __slots__ = ()
    MEMBERSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    membership_id: str
    organization: OrganizationInfo
    role: str
    def __init__(self, membership_id: _Optional[str] = ..., organization: _Optional[_Union[OrganizationInfo, _Mapping]] = ..., role: _Optional[str] = ...) -> None: ...

class OrganizationInfo(_message.Message):
    __slots__ = ()
    ID_FIELD_NUMBER: _ClassVar[int]
    SLUG_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    id: str
    slug: str
    name: str
    def __init__(self, id: _Optional[str] = ..., slug: _Optional[str] = ..., name: _Optional[str] = ...) -> None: ...

class ListInvitationsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    status: InvitationStatus
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., status: _Optional[_Union[InvitationStatus, str]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListInvitationsResponse(_message.Message):
    __slots__ = ()
    INVITATIONS_FIELD_NUMBER: _ClassVar[int]
    TOTAL_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    invitations: _containers.RepeatedCompositeFieldContainer[Invitation]
    total: int
    pagination: _common_pb2.PaginationResponse
    def __init__(self, invitations: _Optional[_Iterable[_Union[Invitation, _Mapping]]] = ..., total: _Optional[int] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetInvitationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., id: _Optional[str] = ...) -> None: ...

class GetInvitationResponse(_message.Message):
    __slots__ = ()
    INVITATION_FIELD_NUMBER: _ClassVar[int]
    invitation: Invitation
    def __init__(self, invitation: _Optional[_Union[Invitation, _Mapping]] = ...) -> None: ...

class RevokeInvitationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., id: _Optional[str] = ...) -> None: ...

class RevokeInvitationResponse(_message.Message):
    __slots__ = ()
    INVITATION_FIELD_NUMBER: _ClassVar[int]
    invitation: Invitation
    def __init__(self, invitation: _Optional[_Union[Invitation, _Mapping]] = ...) -> None: ...

class ResendInvitationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., id: _Optional[str] = ...) -> None: ...

class ResendInvitationResponse(_message.Message):
    __slots__ = ()
    SUCCESS_FIELD_NUMBER: _ClassVar[int]
    INVITATION_URL_FIELD_NUMBER: _ClassVar[int]
    success: bool
    invitation_url: str
    def __init__(self, success: _Optional[bool] = ..., invitation_url: _Optional[str] = ...) -> None: ...
