from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.platform.v1 import organizations_pb2 as _organizations_pb2
from google.protobuf import field_mask_pb2 as _field_mask_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class TeamType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    TEAM_TYPE_UNSPECIFIED: _ClassVar[TeamType]
    TEAM_TYPE_FUNCTIONAL: _ClassVar[TeamType]
    TEAM_TYPE_CROSS_FUNCTIONAL: _ClassVar[TeamType]
    TEAM_TYPE_COMMUNITY: _ClassVar[TeamType]
    TEAM_TYPE_SERVICE: _ClassVar[TeamType]
TEAM_TYPE_UNSPECIFIED: TeamType
TEAM_TYPE_FUNCTIONAL: TeamType
TEAM_TYPE_CROSS_FUNCTIONAL: TeamType
TEAM_TYPE_COMMUNITY: TeamType
TEAM_TYPE_SERVICE: TeamType

class Team(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    TEAM_TYPE_FIELD_NUMBER: _ClassVar[int]
    PARENT_TEAM_ID_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    name: str
    description: str
    team_type: TeamType
    parent_team_id: str
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., team_type: _Optional[_Union[TeamType, str]] = ..., parent_team_id: _Optional[str] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class TeamMembership(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    TEAM_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ROLE_ID_FIELD_NUMBER: _ClassVar[int]
    STATE_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    team_id: str
    user_id: str
    organization_role_id: str
    state: _organizations_pb2.MembershipState
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., team_id: _Optional[str] = ..., user_id: _Optional[str] = ..., organization_role_id: _Optional[str] = ..., state: _Optional[_Union[_organizations_pb2.MembershipState, str]] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class CreateTeamRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TEAM_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    team: Team
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., team: _Optional[_Union[Team, _Mapping]] = ...) -> None: ...

class CreateTeamResponse(_message.Message):
    __slots__ = ()
    TEAM_FIELD_NUMBER: _ClassVar[int]
    team: Team
    def __init__(self, team: _Optional[_Union[Team, _Mapping]] = ...) -> None: ...

class UpdateTeamRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TEAM_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    team: Team
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., team: _Optional[_Union[Team, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateTeamResponse(_message.Message):
    __slots__ = ()
    TEAM_FIELD_NUMBER: _ClassVar[int]
    team: Team
    def __init__(self, team: _Optional[_Union[Team, _Mapping]] = ...) -> None: ...

class DeleteTeamRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TEAM_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    team_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., team_id: _Optional[str] = ...) -> None: ...

class DeleteTeamResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetTeamRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TEAM_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    team_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., team_id: _Optional[str] = ...) -> None: ...

class GetTeamResponse(_message.Message):
    __slots__ = ()
    TEAM_FIELD_NUMBER: _ClassVar[int]
    team: Team
    def __init__(self, team: _Optional[_Union[Team, _Mapping]] = ...) -> None: ...

class ListTeamsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListTeamsResponse(_message.Message):
    __slots__ = ()
    TEAMS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    teams: _containers.RepeatedCompositeFieldContainer[Team]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, teams: _Optional[_Iterable[_Union[Team, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListTeamMembershipsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TEAM_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    team_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., team_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListTeamMembershipsResponse(_message.Message):
    __slots__ = ()
    MEMBERSHIPS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    memberships: _containers.RepeatedCompositeFieldContainer[TeamMembership]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, memberships: _Optional[_Iterable[_Union[TeamMembership, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class UpdateTeamMembershipRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    MEMBERSHIP_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    membership: TeamMembership
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., membership: _Optional[_Union[TeamMembership, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateTeamMembershipResponse(_message.Message):
    __slots__ = ()
    MEMBERSHIP_FIELD_NUMBER: _ClassVar[int]
    membership: TeamMembership
    def __init__(self, membership: _Optional[_Union[TeamMembership, _Mapping]] = ...) -> None: ...
