from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class TenantStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    TENANT_STATUS_UNSPECIFIED: _ClassVar[TenantStatus]
    TENANT_STATUS_ACTIVE: _ClassVar[TenantStatus]
    TENANT_STATUS_SUSPENDED: _ClassVar[TenantStatus]
    TENANT_STATUS_DELETED: _ClassVar[TenantStatus]

class TenantAccessType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    TENANT_ACCESS_TYPE_UNSPECIFIED: _ClassVar[TenantAccessType]
    TENANT_ACCESS_TYPE_OWNER: _ClassVar[TenantAccessType]
    TENANT_ACCESS_TYPE_MEMBER: _ClassVar[TenantAccessType]
TENANT_STATUS_UNSPECIFIED: TenantStatus
TENANT_STATUS_ACTIVE: TenantStatus
TENANT_STATUS_SUSPENDED: TenantStatus
TENANT_STATUS_DELETED: TenantStatus
TENANT_ACCESS_TYPE_UNSPECIFIED: TenantAccessType
TENANT_ACCESS_TYPE_OWNER: TenantAccessType
TENANT_ACCESS_TYPE_MEMBER: TenantAccessType

class Tenant(_message.Message):
    __slots__ = ()
    class MetadataAttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    OWNER_USER_ID_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    METADATA_ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    OWNER_NAME_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_COUNT_FIELD_NUMBER: _ClassVar[int]
    ACCESS_TYPE_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    owner_user_id: str
    display_name: str
    status: TenantStatus
    metadata_attributes: _containers.ScalarMap[str, str]
    owner_name: str
    organization_count: int
    access_type: TenantAccessType
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., owner_user_id: _Optional[str] = ..., display_name: _Optional[str] = ..., status: _Optional[_Union[TenantStatus, str]] = ..., metadata_attributes: _Optional[_Mapping[str, str]] = ..., owner_name: _Optional[str] = ..., organization_count: _Optional[int] = ..., access_type: _Optional[_Union[TenantAccessType, str]] = ...) -> None: ...

class CreateTenantRequest(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    OWNER_USER_ID_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    tenant_id: str
    owner_user_id: str
    display_name: str
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., tenant_id: _Optional[str] = ..., owner_user_id: _Optional[str] = ..., display_name: _Optional[str] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class CreateTenantResponse(_message.Message):
    __slots__ = ()
    TENANT_FIELD_NUMBER: _ClassVar[int]
    tenant: Tenant
    def __init__(self, tenant: _Optional[_Union[Tenant, _Mapping]] = ...) -> None: ...

class GetTenantRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    tenant_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., tenant_id: _Optional[str] = ...) -> None: ...

class GetTenantResponse(_message.Message):
    __slots__ = ()
    TENANT_FIELD_NUMBER: _ClassVar[int]
    tenant: Tenant
    def __init__(self, tenant: _Optional[_Union[Tenant, _Mapping]] = ...) -> None: ...

class ListAccessibleTenantsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    OWNED_ONLY_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    status: TenantStatus
    owned_only: bool
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., status: _Optional[_Union[TenantStatus, str]] = ..., owned_only: _Optional[bool] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListAccessibleTenantsResponse(_message.Message):
    __slots__ = ()
    TENANTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    tenants: _containers.RepeatedCompositeFieldContainer[Tenant]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, tenants: _Optional[_Iterable[_Union[Tenant, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class UpdateTenantRequest(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    tenant_id: str
    display_name: str
    status: TenantStatus
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., tenant_id: _Optional[str] = ..., display_name: _Optional[str] = ..., status: _Optional[_Union[TenantStatus, str]] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class UpdateTenantResponse(_message.Message):
    __slots__ = ()
    TENANT_FIELD_NUMBER: _ClassVar[int]
    tenant: Tenant
    def __init__(self, tenant: _Optional[_Union[Tenant, _Mapping]] = ...) -> None: ...
