import datetime

from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.threads.v1 import threads_types_pb2 as _threads_types_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ListThreadsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    LIMIT_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    limit: int
    page_token: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., limit: _Optional[int] = ..., page_token: _Optional[str] = ...) -> None: ...

class ListThreadsResponse(_message.Message):
    __slots__ = ()
    THREADS_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    threads: _containers.RepeatedCompositeFieldContainer[_threads_types_pb2.ThreadSummary]
    next_page_token: str
    def __init__(self, threads: _Optional[_Iterable[_Union[_threads_types_pb2.ThreadSummary, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...

class GetThreadRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    THREAD_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    thread_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., thread_id: _Optional[str] = ...) -> None: ...

class GetThreadResponse(_message.Message):
    __slots__ = ()
    THREAD_FIELD_NUMBER: _ClassVar[int]
    thread: _threads_types_pb2.Thread
    def __init__(self, thread: _Optional[_Union[_threads_types_pb2.Thread, _Mapping]] = ...) -> None: ...

class ListMessagesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    THREAD_ID_FIELD_NUMBER: _ClassVar[int]
    LIMIT_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    thread_id: str
    limit: int
    page_token: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., thread_id: _Optional[str] = ..., limit: _Optional[int] = ..., page_token: _Optional[str] = ...) -> None: ...

class ListMessagesResponse(_message.Message):
    __slots__ = ()
    MESSAGES_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    messages: _containers.RepeatedCompositeFieldContainer[_threads_types_pb2.ThreadMessage]
    next_page_token: str
    def __init__(self, messages: _Optional[_Iterable[_Union[_threads_types_pb2.ThreadMessage, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...

class AppendMessagesRequest(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    THREAD_ID_FIELD_NUMBER: _ClassVar[int]
    MESSAGES_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    thread_id: str
    messages: _containers.RepeatedCompositeFieldContainer[_threads_types_pb2.ThreadMessage]
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., thread_id: _Optional[str] = ..., messages: _Optional[_Iterable[_Union[_threads_types_pb2.ThreadMessage, _Mapping]]] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class AppendMessagesResponse(_message.Message):
    __slots__ = ()
    THREAD_FIELD_NUMBER: _ClassVar[int]
    thread: _threads_types_pb2.Thread
    def __init__(self, thread: _Optional[_Union[_threads_types_pb2.Thread, _Mapping]] = ...) -> None: ...

class SendMessageRequest(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    THREAD_ID_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    AGENT_ID_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    thread_id: str
    message: _threads_types_pb2.ThreadMessage
    agent_id: str
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., thread_id: _Optional[str] = ..., message: _Optional[_Union[_threads_types_pb2.ThreadMessage, _Mapping]] = ..., agent_id: _Optional[str] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class MessageStarted(_message.Message):
    __slots__ = ()
    MESSAGE_ID_FIELD_NUMBER: _ClassVar[int]
    THREAD_ID_FIELD_NUMBER: _ClassVar[int]
    STARTED_AT_FIELD_NUMBER: _ClassVar[int]
    message_id: str
    thread_id: str
    started_at: _timestamp_pb2.Timestamp
    def __init__(self, message_id: _Optional[str] = ..., thread_id: _Optional[str] = ..., started_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class MessageToken(_message.Message):
    __slots__ = ()
    CONTENT_FIELD_NUMBER: _ClassVar[int]
    content: str
    def __init__(self, content: _Optional[str] = ...) -> None: ...

class MessageCompleted(_message.Message):
    __slots__ = ()
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    THREAD_FIELD_NUMBER: _ClassVar[int]
    message: _threads_types_pb2.ThreadMessage
    thread: _threads_types_pb2.Thread
    def __init__(self, message: _Optional[_Union[_threads_types_pb2.ThreadMessage, _Mapping]] = ..., thread: _Optional[_Union[_threads_types_pb2.Thread, _Mapping]] = ...) -> None: ...

class MessageError(_message.Message):
    __slots__ = ()
    CODE_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    code: str
    message: str
    def __init__(self, code: _Optional[str] = ..., message: _Optional[str] = ...) -> None: ...

class SendMessageResponse(_message.Message):
    __slots__ = ()
    STARTED_FIELD_NUMBER: _ClassVar[int]
    TOKEN_FIELD_NUMBER: _ClassVar[int]
    COMPLETED_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    started: MessageStarted
    token: MessageToken
    completed: MessageCompleted
    error: MessageError
    def __init__(self, started: _Optional[_Union[MessageStarted, _Mapping]] = ..., token: _Optional[_Union[MessageToken, _Mapping]] = ..., completed: _Optional[_Union[MessageCompleted, _Mapping]] = ..., error: _Optional[_Union[MessageError, _Mapping]] = ...) -> None: ...
