import datetime

from google.protobuf import struct_pb2 as _struct_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class WorkflowDefinitionStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    WORKFLOW_DEFINITION_STATUS_UNSPECIFIED: _ClassVar[WorkflowDefinitionStatus]
    WORKFLOW_DEFINITION_STATUS_DRAFT: _ClassVar[WorkflowDefinitionStatus]
    WORKFLOW_DEFINITION_STATUS_ACTIVE: _ClassVar[WorkflowDefinitionStatus]
    WORKFLOW_DEFINITION_STATUS_ARCHIVED: _ClassVar[WorkflowDefinitionStatus]

class WorkflowVersionStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    WORKFLOW_VERSION_STATUS_UNSPECIFIED: _ClassVar[WorkflowVersionStatus]
    WORKFLOW_VERSION_STATUS_DRAFT: _ClassVar[WorkflowVersionStatus]
    WORKFLOW_VERSION_STATUS_PENDING_APPROVAL: _ClassVar[WorkflowVersionStatus]
    WORKFLOW_VERSION_STATUS_PUBLISHED: _ClassVar[WorkflowVersionStatus]
    WORKFLOW_VERSION_STATUS_DEPRECATED: _ClassVar[WorkflowVersionStatus]
    WORKFLOW_VERSION_STATUS_ARCHIVED: _ClassVar[WorkflowVersionStatus]

class WorkflowRunStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    WORKFLOW_RUN_STATUS_UNSPECIFIED: _ClassVar[WorkflowRunStatus]
    WORKFLOW_RUN_STATUS_PENDING: _ClassVar[WorkflowRunStatus]
    WORKFLOW_RUN_STATUS_RUNNING: _ClassVar[WorkflowRunStatus]
    WORKFLOW_RUN_STATUS_COMPLETED: _ClassVar[WorkflowRunStatus]
    WORKFLOW_RUN_STATUS_FAILED: _ClassVar[WorkflowRunStatus]
    WORKFLOW_RUN_STATUS_CANCELLED: _ClassVar[WorkflowRunStatus]
WORKFLOW_DEFINITION_STATUS_UNSPECIFIED: WorkflowDefinitionStatus
WORKFLOW_DEFINITION_STATUS_DRAFT: WorkflowDefinitionStatus
WORKFLOW_DEFINITION_STATUS_ACTIVE: WorkflowDefinitionStatus
WORKFLOW_DEFINITION_STATUS_ARCHIVED: WorkflowDefinitionStatus
WORKFLOW_VERSION_STATUS_UNSPECIFIED: WorkflowVersionStatus
WORKFLOW_VERSION_STATUS_DRAFT: WorkflowVersionStatus
WORKFLOW_VERSION_STATUS_PENDING_APPROVAL: WorkflowVersionStatus
WORKFLOW_VERSION_STATUS_PUBLISHED: WorkflowVersionStatus
WORKFLOW_VERSION_STATUS_DEPRECATED: WorkflowVersionStatus
WORKFLOW_VERSION_STATUS_ARCHIVED: WorkflowVersionStatus
WORKFLOW_RUN_STATUS_UNSPECIFIED: WorkflowRunStatus
WORKFLOW_RUN_STATUS_PENDING: WorkflowRunStatus
WORKFLOW_RUN_STATUS_RUNNING: WorkflowRunStatus
WORKFLOW_RUN_STATUS_COMPLETED: WorkflowRunStatus
WORKFLOW_RUN_STATUS_FAILED: WorkflowRunStatus
WORKFLOW_RUN_STATUS_CANCELLED: WorkflowRunStatus

class WorkflowDefinition(_message.Message):
    __slots__ = ()
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_KEY_FIELD_NUMBER: _ClassVar[int]
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    CATEGORY_FIELD_NUMBER: _ClassVar[int]
    TAGS_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_QUEUE_FIELD_NUMBER: _ClassVar[int]
    OWNER_USER_ID_FIELD_NUMBER: _ClassVar[int]
    ANNOTATIONS_FIELD_NUMBER: _ClassVar[int]
    LATEST_VERSION_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    definition_key: str
    display_name: str
    description: str
    category: str
    tags: _containers.RepeatedScalarFieldContainer[str]
    status: WorkflowDefinitionStatus
    default_queue: str
    owner_user_id: str
    annotations: _struct_pb2.Struct
    latest_version: WorkflowVersion
    created_at: _timestamp_pb2.Timestamp
    updated_at: _timestamp_pb2.Timestamp
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., definition_key: _Optional[str] = ..., display_name: _Optional[str] = ..., description: _Optional[str] = ..., category: _Optional[str] = ..., tags: _Optional[_Iterable[str]] = ..., status: _Optional[_Union[WorkflowDefinitionStatus, str]] = ..., default_queue: _Optional[str] = ..., owner_user_id: _Optional[str] = ..., annotations: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., latest_version: _Optional[_Union[WorkflowVersion, _Mapping]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class WorkflowVersion(_message.Message):
    __slots__ = ()
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_NUMBER_FIELD_NUMBER: _ClassVar[int]
    VERSION_TAG_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    SPEC_FIELD_NUMBER: _ClassVar[int]
    RUNTIME_PARAMETERS_FIELD_NUMBER: _ClassVar[int]
    CHANGELOG_FIELD_NUMBER: _ClassVar[int]
    ANNOTATIONS_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_USER_ID_FIELD_NUMBER: _ClassVar[int]
    PUBLISHED_BY_USER_ID_FIELD_NUMBER: _ClassVar[int]
    PUBLISHED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    definition_id: str
    version_number: int
    version_tag: str
    status: WorkflowVersionStatus
    spec: _struct_pb2.Struct
    runtime_parameters: _struct_pb2.Struct
    changelog: str
    annotations: _struct_pb2.Struct
    created_by_user_id: str
    published_by_user_id: str
    published_at: _timestamp_pb2.Timestamp
    created_at: _timestamp_pb2.Timestamp
    updated_at: _timestamp_pb2.Timestamp
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., version_number: _Optional[int] = ..., version_tag: _Optional[str] = ..., status: _Optional[_Union[WorkflowVersionStatus, str]] = ..., spec: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., runtime_parameters: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., changelog: _Optional[str] = ..., annotations: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., created_by_user_id: _Optional[str] = ..., published_by_user_id: _Optional[str] = ..., published_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class WorkflowRun(_message.Message):
    __slots__ = ()
    WORKFLOWS_ID_FIELD_NUMBER: _ClassVar[int]
    RUN_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    STATUS_DETAILS_FIELD_NUMBER: _ClassVar[int]
    START_TIME_FIELD_NUMBER: _ClassVar[int]
    CLOSE_TIME_FIELD_NUMBER: _ClassVar[int]
    HISTORY_LENGTH_FIELD_NUMBER: _ClassVar[int]
    MEMO_FIELD_NUMBER: _ClassVar[int]
    SEARCH_ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    workflows_id: str
    run_id: str
    status: str
    status_details: str
    start_time: _timestamp_pb2.Timestamp
    close_time: _timestamp_pb2.Timestamp
    history_length: int
    memo: _struct_pb2.Struct
    search_attributes: _struct_pb2.Struct
    def __init__(self, workflows_id: _Optional[str] = ..., run_id: _Optional[str] = ..., status: _Optional[str] = ..., status_details: _Optional[str] = ..., start_time: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., close_time: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., history_length: _Optional[int] = ..., memo: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., search_attributes: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ...) -> None: ...

class WorkflowRule(_message.Message):
    __slots__ = ()
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    RULE_NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    GRAPH_ID_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    TRIGGER_EVENT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_TYPE_FILTER_FIELD_NUMBER: _ClassVar[int]
    LIFECYCLE_STATE_FILTER_FIELD_NUMBER: _ClassVar[int]
    ENABLED_FIELD_NUMBER: _ClassVar[int]
    TASK_QUEUE_FIELD_NUMBER: _ClassVar[int]
    WORKFLOWS_INPUT_FIELD_NUMBER: _ClassVar[int]
    EXECUTION_COUNT_FIELD_NUMBER: _ClassVar[int]
    SUCCESS_COUNT_FIELD_NUMBER: _ClassVar[int]
    FAILURE_COUNT_FIELD_NUMBER: _ClassVar[int]
    LAST_EXECUTED_AT_FIELD_NUMBER: _ClassVar[int]
    LAST_EXECUTION_STATUS_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    definition_id: str
    rule_name: str
    description: str
    graph_id: str
    transformation_id: str
    trigger_event: str
    element_type_filter: str
    lifecycle_state_filter: str
    enabled: bool
    task_queue: str
    workflows_input: _struct_pb2.Struct
    execution_count: int
    success_count: int
    failure_count: int
    last_executed_at: _timestamp_pb2.Timestamp
    last_execution_status: str
    created_at: _timestamp_pb2.Timestamp
    updated_at: _timestamp_pb2.Timestamp
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., rule_name: _Optional[str] = ..., description: _Optional[str] = ..., graph_id: _Optional[str] = ..., transformation_id: _Optional[str] = ..., trigger_event: _Optional[str] = ..., element_type_filter: _Optional[str] = ..., lifecycle_state_filter: _Optional[str] = ..., enabled: _Optional[bool] = ..., task_queue: _Optional[str] = ..., workflows_input: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., execution_count: _Optional[int] = ..., success_count: _Optional[int] = ..., failure_count: _Optional[int] = ..., last_executed_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., last_execution_status: _Optional[str] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class WorkflowStatusUpdate(_message.Message):
    __slots__ = ()
    EXECUTION_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    STEP_FIELD_NUMBER: _ClassVar[int]
    DETAILS_FIELD_NUMBER: _ClassVar[int]
    execution_id: str
    status: WorkflowRunStatus
    message: str
    step: str
    details: _struct_pb2.Struct
    def __init__(self, execution_id: _Optional[str] = ..., status: _Optional[_Union[WorkflowRunStatus, str]] = ..., message: _Optional[str] = ..., step: _Optional[str] = ..., details: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ...) -> None: ...

class WorkflowDefinitionInput(_message.Message):
    __slots__ = ()
    DISPLAY_NAME_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_KEY_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    CATEGORY_FIELD_NUMBER: _ClassVar[int]
    TAGS_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_QUEUE_FIELD_NUMBER: _ClassVar[int]
    OWNER_USER_ID_FIELD_NUMBER: _ClassVar[int]
    ANNOTATIONS_FIELD_NUMBER: _ClassVar[int]
    display_name: str
    definition_key: str
    description: str
    category: str
    tags: _containers.RepeatedScalarFieldContainer[str]
    default_queue: str
    owner_user_id: str
    annotations: _struct_pb2.Struct
    def __init__(self, display_name: _Optional[str] = ..., definition_key: _Optional[str] = ..., description: _Optional[str] = ..., category: _Optional[str] = ..., tags: _Optional[_Iterable[str]] = ..., default_queue: _Optional[str] = ..., owner_user_id: _Optional[str] = ..., annotations: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ...) -> None: ...

class WorkflowVersionInput(_message.Message):
    __slots__ = ()
    SPEC_FIELD_NUMBER: _ClassVar[int]
    RUNTIME_PARAMETERS_FIELD_NUMBER: _ClassVar[int]
    VERSION_TAG_FIELD_NUMBER: _ClassVar[int]
    CHANGELOG_FIELD_NUMBER: _ClassVar[int]
    ANNOTATIONS_FIELD_NUMBER: _ClassVar[int]
    PUBLISH_FIELD_NUMBER: _ClassVar[int]
    spec: _struct_pb2.Struct
    runtime_parameters: _struct_pb2.Struct
    version_tag: str
    changelog: str
    annotations: _struct_pb2.Struct
    publish: bool
    def __init__(self, spec: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., runtime_parameters: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., version_tag: _Optional[str] = ..., changelog: _Optional[str] = ..., annotations: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., publish: _Optional[bool] = ...) -> None: ...

class WorkflowRuleInput(_message.Message):
    __slots__ = ()
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    RULE_NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    GRAPH_ID_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    TRIGGER_EVENT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_TYPE_FILTER_FIELD_NUMBER: _ClassVar[int]
    LIFECYCLE_STATE_FILTER_FIELD_NUMBER: _ClassVar[int]
    ENABLED_FIELD_NUMBER: _ClassVar[int]
    TASK_QUEUE_FIELD_NUMBER: _ClassVar[int]
    WORKFLOWS_INPUT_FIELD_NUMBER: _ClassVar[int]
    definition_id: str
    rule_name: str
    description: str
    graph_id: str
    transformation_id: str
    trigger_event: str
    element_type_filter: str
    lifecycle_state_filter: str
    enabled: bool
    task_queue: str
    workflows_input: _struct_pb2.Struct
    def __init__(self, definition_id: _Optional[str] = ..., rule_name: _Optional[str] = ..., description: _Optional[str] = ..., graph_id: _Optional[str] = ..., transformation_id: _Optional[str] = ..., trigger_event: _Optional[str] = ..., element_type_filter: _Optional[str] = ..., lifecycle_state_filter: _Optional[str] = ..., enabled: _Optional[bool] = ..., task_queue: _Optional[str] = ..., workflows_input: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ...) -> None: ...

class WorkflowRulePatch(_message.Message):
    __slots__ = ()
    RULE_NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    TRIGGER_EVENT_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_TYPE_FILTER_FIELD_NUMBER: _ClassVar[int]
    LIFECYCLE_STATE_FILTER_FIELD_NUMBER: _ClassVar[int]
    ENABLED_FIELD_NUMBER: _ClassVar[int]
    TASK_QUEUE_FIELD_NUMBER: _ClassVar[int]
    WORKFLOWS_INPUT_FIELD_NUMBER: _ClassVar[int]
    rule_name: str
    description: str
    trigger_event: str
    element_type_filter: str
    lifecycle_state_filter: str
    enabled: bool
    task_queue: str
    workflows_input: _struct_pb2.Struct
    def __init__(self, rule_name: _Optional[str] = ..., description: _Optional[str] = ..., trigger_event: _Optional[str] = ..., element_type_filter: _Optional[str] = ..., lifecycle_state_filter: _Optional[str] = ..., enabled: _Optional[bool] = ..., task_queue: _Optional[str] = ..., workflows_input: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ...) -> None: ...
