# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import base_t
from . import entity_t
from . import identifier_t

__all__: list[str] = [
    "ArgumentValueId",
    "ArgumentValueRefName",
    "FieldArgumentValue",
    "FieldRefIdNameValue",
    "FieldRefNameValue",
    "FieldValue",
    "FieldValueBase",
    "FieldValueBatchReference",
    "FieldValueBoolean",
    "FieldValueFiles",
    "FieldValueId",
    "FieldValueIds",
    "FieldValueNumeric",
    "FieldValueText",
    "FieldValueType",
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldRefNameValue",
    unconverted_values={"value"},
)
@dataclasses.dataclass(kw_only=True)
class FieldRefNameValue:
    field_ref_name: str
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldRefIdNameValue",
    unconverted_values={"value"},
)
@dataclasses.dataclass(kw_only=True)
class FieldRefIdNameValue:
    field_id: base_t.ObjectId
    field_ref_name: str
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.ArgumentValueRefName",
    unconverted_values={"value"},
)
@dataclasses.dataclass(kw_only=True)
class ArgumentValueRefName:
    field_ref_name: str
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.ArgumentValueId",
    unconverted_values={"value"},
)
@dataclasses.dataclass(kw_only=True)
class ArgumentValueId:
    field_id: base_t.ObjectId
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
class FieldValueType(StrEnum):
    FILES = "files"
    TEXT = "text"
    ID = "id"
    IDS = "ids"
    BOOLEAN = "boolean"
    NUMERIC = "numeric"
    BATCH_REFERENCE = "batch_reference"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueBase",
)
@dataclasses.dataclass(kw_only=True)
class FieldValueBase:
    type: FieldValueType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueFiles",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueFiles(FieldValueBase):
    type: typing.Literal[FieldValueType.FILES] = FieldValueType.FILES
    file_ids: list[base_t.ObjectId]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueId",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueId(FieldValueBase):
    type: typing.Literal[FieldValueType.ID] = FieldValueType.ID
    entity_type: entity_t.EntityType
    identifier_key: identifier_t.IdentifierKey


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueIds",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueIds(FieldValueBase):
    type: typing.Literal[FieldValueType.IDS] = FieldValueType.IDS
    entity_type: entity_t.EntityType
    identifier_keys: list[identifier_t.IdentifierKey]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueText",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueText(FieldValueBase):
    type: typing.Literal[FieldValueType.TEXT] = FieldValueType.TEXT
    value: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueBoolean",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueBoolean(FieldValueBase):
    type: typing.Literal[FieldValueType.BOOLEAN] = FieldValueType.BOOLEAN
    value: bool


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueNumeric",
    to_string_values={"value"},
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueNumeric(FieldValueBase):
    type: typing.Literal[FieldValueType.NUMERIC] = FieldValueType.NUMERIC
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueBatchReference",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class FieldValueBatchReference(FieldValueBase):
    type: typing.Literal[FieldValueType.BATCH_REFERENCE] = FieldValueType.BATCH_REFERENCE
    reference_key: identifier_t.IdentifierKeyBatchReference
    data_key: str


# DO NOT MODIFY -- This file is generated by type_spec
FieldValue = typing.Annotated[
    FieldValueFiles | FieldValueId | FieldValueIds | FieldValueText | FieldValueBoolean | FieldValueNumeric | FieldValueBatchReference,
    serial_union_annotation(
    named_type_path="sdk.field_values.FieldValue",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldArgumentValue",
)
@dataclasses.dataclass(kw_only=True)
class FieldArgumentValue:
    field_key: identifier_t.IdentifierKey
    value: FieldValue
# DO NOT MODIFY -- This file is generated by type_spec
