# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import auth_retrieval_t
from . import client_config_t
from . import generic_upload_t
from . import identifier_t
from . import integration_server_t
from . import secret_retrieval_t

__all__: list[str] = [
    "CronJobDefinition",
    "GenericUploadDataSource",
    "GenericUploadDataSourceBase",
    "GenericUploadDataSourceS3",
    "GenericUploadDataSourceSFTP",
    "GenericUploadDataSourceType",
    "JobDefinition",
    "JobDefinitionBase",
    "JobDefinitionType",
    "JobExecutor",
    "JobExecutorBase",
    "JobExecutorGenericUpload",
    "JobExecutorScript",
    "JobExecutorType",
    "JobLoggingSettings",
    "JobResult",
    "ProfileDefinition",
    "ProfileMetadata",
    "S3CloudProvider",
    "WebhookJobDefinition",
]


# DO NOT MODIFY -- This file is generated by type_spec
class JobDefinitionType(StrEnum):
    CRON = "cron"
    WEBHOOK = "webhook"


# DO NOT MODIFY -- This file is generated by type_spec
class JobExecutorType(StrEnum):
    SCRIPT = "script"
    GENERIC_UPLOAD = "generic_upload"


# DO NOT MODIFY -- This file is generated by type_spec
class GenericUploadDataSourceType(StrEnum):
    SFTP = "sftp"
    S3 = "s3"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.JobExecutorBase",
)
@dataclasses.dataclass(kw_only=True)
class JobExecutorBase:
    type: JobExecutorType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.JobExecutorScript",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class JobExecutorScript(JobExecutorBase):
    type: typing.Literal[JobExecutorType.SCRIPT] = JobExecutorType.SCRIPT
    import_path: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.GenericUploadDataSourceBase",
)
@dataclasses.dataclass(kw_only=True)
class GenericUploadDataSourceBase:
    type: GenericUploadDataSourceType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.GenericUploadDataSourceSFTP",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class GenericUploadDataSourceSFTP(GenericUploadDataSourceBase):
    type: typing.Literal[GenericUploadDataSourceType.SFTP] = GenericUploadDataSourceType.SFTP
    host: str
    username: str
    pem_secret: secret_retrieval_t.SecretRetrieval | None = None
    password_secret: secret_retrieval_t.SecretRetrieval | None = None


# DO NOT MODIFY -- This file is generated by type_spec
class S3CloudProvider(StrEnum):
    OVH = "ovh"
    AWS = "aws"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.GenericUploadDataSourceS3",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class GenericUploadDataSourceS3(GenericUploadDataSourceBase):
    type: typing.Literal[GenericUploadDataSourceType.S3] = GenericUploadDataSourceType.S3
    bucket_name: str
    cloud_provider: S3CloudProvider | None = None
    endpoint_url: str | None = None
    region_name: str | None = None
    access_key_id: str | None = None
    access_key_secret: secret_retrieval_t.SecretRetrieval | None = None


# DO NOT MODIFY -- This file is generated by type_spec
GenericUploadDataSource = typing.Annotated[
    GenericUploadDataSourceSFTP | GenericUploadDataSourceS3,
    serial_union_annotation(
    named_type_path="sdk.job_definition.GenericUploadDataSource",
        discriminator="type",
        discriminator_map={
            "sftp": GenericUploadDataSourceSFTP,
            "s3": GenericUploadDataSourceS3,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.JobExecutorGenericUpload",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class JobExecutorGenericUpload(JobExecutorBase):
    type: typing.Literal[JobExecutorType.GENERIC_UPLOAD] = JobExecutorType.GENERIC_UPLOAD
    data_source: GenericUploadDataSource
    upload_strategy: generic_upload_t.GenericUploadStrategy
    remote_directories: list[generic_upload_t.GenericRemoteDirectoryScope]


# DO NOT MODIFY -- This file is generated by type_spec
JobExecutor = typing.Annotated[
    JobExecutorScript | JobExecutorGenericUpload,
    serial_union_annotation(
    named_type_path="sdk.job_definition.JobExecutor",
        discriminator="type",
        discriminator_map={
            "script": JobExecutorScript,
            "generic_upload": JobExecutorGenericUpload,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.JobLoggingSettings",
)
@dataclasses.dataclass(kw_only=True)
class JobLoggingSettings:
    enabled: bool = False
    share_with_user_groups: list[identifier_t.IdentifierKey] | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.JobDefinitionBase",
)
@dataclasses.dataclass(kw_only=True)
class JobDefinitionBase:
    id: str
    name: str
    executor: JobExecutor
    enabled: bool = True
    logging_settings: JobLoggingSettings | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.CronJobDefinition",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class CronJobDefinition(JobDefinitionBase):
    type: typing.Literal[JobDefinitionType.CRON] = JobDefinitionType.CRON
    cron_spec: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.WebhookJobDefinition",
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class WebhookJobDefinition(JobDefinitionBase):
    type: typing.Literal[JobDefinitionType.WEBHOOK] = JobDefinitionType.WEBHOOK
    signature_key_secret: secret_retrieval_t.SecretRetrieval


# DO NOT MODIFY -- This file is generated by type_spec
JobDefinition = typing.Annotated[
    CronJobDefinition | WebhookJobDefinition,
    serial_union_annotation(
    named_type_path="sdk.job_definition.JobDefinition",
        discriminator="type",
        discriminator_map={
            "cron": CronJobDefinition,
            "webhook": WebhookJobDefinition,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.ProfileDefinition",
)
@dataclasses.dataclass(kw_only=True)
class ProfileDefinition:
    jobs: list[JobDefinition]
    auth_retrieval: auth_retrieval_t.AuthRetrieval | None = None
    base_url: str | None = None
    client_options: client_config_t.ClientConfigOptions | None = None
    environments: dict[integration_server_t.IntegrationEnvironment, integration_server_t.EnvironmentConfig] | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.ProfileMetadata",
)
@dataclasses.dataclass(kw_only=True)
class ProfileMetadata:
    name: str
    base_url: str
    auth_retrieval: auth_retrieval_t.AuthRetrieval
    client_options: client_config_t.ClientConfigOptions | None
    jobs: list[JobDefinition]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.job_definition.JobResult",
)
@dataclasses.dataclass(kw_only=True)
class JobResult:
    success: bool
# DO NOT MODIFY -- This file is generated by type_spec
