from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .schema_descriptor import SchemaDescriptor

@dataclass
class LabelInfo(AdditionalDataHolder, Parsable):
    # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
    additional_data: Dict[str, Any] = field(default_factory=dict)

    # Is label a filtering label?
    filtering: Optional[bool] = None
    # Is label a metrics label?
    metrics: Optional[bool] = None
    # Label name
    name: Optional[str] = None
    # List of schemas where label is referenced
    schemas: Optional[List[SchemaDescriptor]] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: ParseNode) -> LabelInfo:
        """
        Creates a new instance of the appropriate class based on discriminator value
        param parse_node: The parse node to use to read the discriminator value and create the object
        Returns: LabelInfo
        """
        if parse_node is None:
            raise TypeError("parse_node cannot be null.")
        return LabelInfo()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .schema_descriptor import SchemaDescriptor

        from .schema_descriptor import SchemaDescriptor

        fields: Dict[str, Callable[[Any], None]] = {
            "filtering": lambda n : setattr(self, 'filtering', n.get_bool_value()),
            "metrics": lambda n : setattr(self, 'metrics', n.get_bool_value()),
            "name": lambda n : setattr(self, 'name', n.get_str_value()),
            "schemas": lambda n : setattr(self, 'schemas', n.get_collection_of_object_values(SchemaDescriptor)),
        }
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        param writer: Serialization writer to use to serialize this model
        Returns: None
        """
        if writer is None:
            raise TypeError("writer cannot be null.")
        writer.write_bool_value("filtering", self.filtering)
        writer.write_bool_value("metrics", self.metrics)
        writer.write_str_value("name", self.name)
        writer.write_collection_of_object_values("schemas", self.schemas)
        writer.write_additional_data_value(self.additional_data)
    

