__version__ = "0.1.2"

import pandas as pd
import os
import cv2
from matplotlib import pyplot as plt

def show_images_from_cluster(excel_path, image_folder, cluster_id, num_images=5):
    df = pd.read_excel(excel_path)
    cluster_images = df[df['Cluster'] == cluster_id]['ISIN'].tolist()[:num_images]

    if not cluster_images:
        print(f"No images found for Cluster {cluster_id}!")
        return

    fig, axes = plt.subplots(1, len(cluster_images), figsize=(15, 5))
    if len(cluster_images) == 1:
        axes = [axes]

    for ax, image_name in zip(axes, cluster_images):
        image_path = os.path.join(image_folder, image_name)
        if os.path.exists(image_path):
            img = cv2.imread(image_path)
            img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
            ax.imshow(img)
            ax.set_title(image_name)
            ax.axis("off")
        else:
            print(f"Image not found: {image_path}")

    plt.show()


if __name__ == "__main__":
    main()
