__version__ = "0.1.2"

import pypdfium2 as pdfium
from PIL import Image
import numpy as np
import os
import cv2
import sqlite3
from tqdm import tqdm

def convert_image_to_grayscale(image):
    return cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)

def threshold_image(grayscale_image):
    return cv2.threshold(grayscale_image, 0, 255, cv2.THRESH_BINARY + cv2.THRESH_OTSU)[1]

def invert_image(thresholded_image):
    return cv2.bitwise_not(thresholded_image)

def dilate_image(inverted_image, iterations=4):
    return cv2.dilate(inverted_image, None, iterations=iterations)

def analyze_doc_skeleton(pdf_page, scale, dilation):
    page_image = pdf_page.render(scale=scale).to_pil()
    image = np.array(page_image)
    gs_img = convert_image_to_grayscale(image)
    th_img = threshold_image(gs_img)
    inv_img = invert_image(th_img)
    dilated_image = dilate_image(inv_img, iterations=dilation)
    return Image.fromarray(dilated_image)

def textshade(pdf_paths, output_image_path, nod, dilation):
    for file_path in tqdm(pdf_paths[:nod], desc="Processing PDFs", unit="file"):
        pdf = pdfium.PdfDocument(os.path.join(file_path))
        pdf_page = pdf[0]
        skeleton = analyze_doc_skeleton(pdf_page, scale=4, dilation=dilation)
        pdf_name = os.path.basename(file_path).split(".pdf")[0]
        skeleton.save(f"{output_image_path}/{pdf_name}-0.png")

if __name__ == "__main__":
    main()
