# coding: utf-8

# Copyright 2024, Pulumi Corporation.  All rights reserved.

"""
    ESC (Environments, Secrets, Config) API

    Pulumi ESC allows you to compose and manage hierarchical collections of configuration and secrets and consume them in various ways.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from pulumi_esc_sdk.models.check_environment import CheckEnvironment
from pulumi_esc_sdk.models.clone_environment import CloneEnvironment
from pulumi_esc_sdk.models.create_environment import CreateEnvironment
from pulumi_esc_sdk.models.create_environment_revision_tag import CreateEnvironmentRevisionTag
from pulumi_esc_sdk.models.create_environment_tag import CreateEnvironmentTag
from pulumi_esc_sdk.models.environment import Environment
from pulumi_esc_sdk.models.environment_definition import EnvironmentDefinition
from pulumi_esc_sdk.models.environment_diagnostics import EnvironmentDiagnostics
from pulumi_esc_sdk.models.environment_revision import EnvironmentRevision
from pulumi_esc_sdk.models.environment_revision_tag import EnvironmentRevisionTag
from pulumi_esc_sdk.models.environment_revision_tags import EnvironmentRevisionTags
from pulumi_esc_sdk.models.environment_tag import EnvironmentTag
from pulumi_esc_sdk.models.error import Error
from pulumi_esc_sdk.models.list_environment_tags import ListEnvironmentTags
from pulumi_esc_sdk.models.open_environment import OpenEnvironment
from pulumi_esc_sdk.models.org_environments import OrgEnvironments
from pulumi_esc_sdk.models.update_environment_revision_tag import UpdateEnvironmentRevisionTag
from pulumi_esc_sdk.models.update_environment_tag import UpdateEnvironmentTag
from pulumi_esc_sdk.models.value import Value

from pulumi_esc_sdk.api_client import ApiClient, RequestSerialized
from pulumi_esc_sdk.api_response import ApiResponse
from pulumi_esc_sdk.rest import RESTResponseType


class EscApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def check_environment_yaml(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        body: Annotated[StrictStr, Field(description="Environment Yaml content")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckEnvironment:
        """Checks an environment definition for errors

        Checks an environment definition for errors

        :param org_name: Organization name (required)
        :type org_name: str
        :param body: Environment Yaml content (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_environment_yaml_serialize(
            org_name=org_name,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEnvironment",
            '400': "CheckEnvironment",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def check_environment_yaml_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        body: Annotated[StrictStr, Field(description="Environment Yaml content")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckEnvironment]:
        """Checks an environment definition for errors

        Checks an environment definition for errors

        :param org_name: Organization name (required)
        :type org_name: str
        :param body: Environment Yaml content (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_environment_yaml_serialize(
            org_name=org_name,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEnvironment",
            '400': "CheckEnvironment",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def check_environment_yaml_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        body: Annotated[StrictStr, Field(description="Environment Yaml content")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Checks an environment definition for errors

        Checks an environment definition for errors

        :param org_name: Organization name (required)
        :type org_name: str
        :param body: Environment Yaml content (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_environment_yaml_serialize(
            org_name=org_name,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEnvironment",
            '400': "CheckEnvironment",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_environment_yaml_serialize(
        self,
        org_name,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/x-yaml'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}/yaml/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def clone_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        clone_environment: Annotated[CloneEnvironment, Field(description="Clone environment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Clones an environment

        Clones an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param clone_environment: Clone environment (required)
        :type clone_environment: CloneEnvironment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._clone_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            clone_environment=clone_environment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def clone_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        clone_environment: Annotated[CloneEnvironment, Field(description="Clone environment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Clones an environment

        Clones an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param clone_environment: Clone environment (required)
        :type clone_environment: CloneEnvironment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._clone_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            clone_environment=clone_environment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def clone_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        clone_environment: Annotated[CloneEnvironment, Field(description="Clone environment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Clones an environment

        Clones an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param clone_environment: Clone environment (required)
        :type clone_environment: CloneEnvironment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._clone_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            clone_environment=clone_environment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _clone_environment_serialize(
        self,
        org_name,
        project_name,
        env_name,
        clone_environment,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if clone_environment is not None:
            _body_params = clone_environment


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}/{projectName}/{envName}/clone',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        create_environment: Annotated[CreateEnvironment, Field(description="Create Environment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Error:
        """Create a new environment

        Creates an environment in the given org with the given name.

        :param org_name: Organization name (required)
        :type org_name: str
        :param create_environment: Create Environment (required)
        :type create_environment: CreateEnvironment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_serialize(
            org_name=org_name,
            create_environment=create_environment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Error",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        create_environment: Annotated[CreateEnvironment, Field(description="Create Environment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Error]:
        """Create a new environment

        Creates an environment in the given org with the given name.

        :param org_name: Organization name (required)
        :type org_name: str
        :param create_environment: Create Environment (required)
        :type create_environment: CreateEnvironment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_serialize(
            org_name=org_name,
            create_environment=create_environment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Error",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        create_environment: Annotated[CreateEnvironment, Field(description="Create Environment")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new environment

        Creates an environment in the given org with the given name.

        :param org_name: Organization name (required)
        :type org_name: str
        :param create_environment: Create Environment (required)
        :type create_environment: CreateEnvironment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_serialize(
            org_name=org_name,
            create_environment=create_environment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Error",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_environment_serialize(
        self,
        org_name,
        create_environment,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_environment is not None:
            _body_params = create_environment


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_environment_revision_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        create_environment_revision_tag: Annotated[CreateEnvironmentRevisionTag, Field(description="Create environment revision tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create environment revision tag

        Create environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param create_environment_revision_tag: Create environment revision tag (required)
        :type create_environment_revision_tag: CreateEnvironmentRevisionTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            create_environment_revision_tag=create_environment_revision_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_environment_revision_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        create_environment_revision_tag: Annotated[CreateEnvironmentRevisionTag, Field(description="Create environment revision tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create environment revision tag

        Create environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param create_environment_revision_tag: Create environment revision tag (required)
        :type create_environment_revision_tag: CreateEnvironmentRevisionTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            create_environment_revision_tag=create_environment_revision_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_environment_revision_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        create_environment_revision_tag: Annotated[CreateEnvironmentRevisionTag, Field(description="Create environment revision tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create environment revision tag

        Create environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param create_environment_revision_tag: Create environment revision tag (required)
        :type create_environment_revision_tag: CreateEnvironmentRevisionTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            create_environment_revision_tag=create_environment_revision_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_environment_revision_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        create_environment_revision_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_environment_revision_tag is not None:
            _body_params = create_environment_revision_tag


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_environment_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        create_environment_tag: Annotated[CreateEnvironmentTag, Field(description="Create environment tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentTag:
        """Create environment tag

        Create environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param create_environment_tag: Create environment tag (required)
        :type create_environment_tag: CreateEnvironmentTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            create_environment_tag=create_environment_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_environment_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        create_environment_tag: Annotated[CreateEnvironmentTag, Field(description="Create environment tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentTag]:
        """Create environment tag

        Create environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param create_environment_tag: Create environment tag (required)
        :type create_environment_tag: CreateEnvironmentTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            create_environment_tag=create_environment_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_environment_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        create_environment_tag: Annotated[CreateEnvironmentTag, Field(description="Create environment tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create environment tag

        Create environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param create_environment_tag: Create environment tag (required)
        :type create_environment_tag: CreateEnvironmentTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            create_environment_tag=create_environment_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_environment_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        create_environment_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_environment_tag is not None:
            _body_params = create_environment_tag


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}/{projectName}/{envName}/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def decrypt_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentDefinition:
        """Reads the definition for the given environment with static secrets in plaintext

        Reads the definition for the given environment with static secrets in plaintext

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._decrypt_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def decrypt_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentDefinition]:
        """Reads the definition for the given environment with static secrets in plaintext

        Reads the definition for the given environment with static secrets in plaintext

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._decrypt_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def decrypt_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reads the definition for the given environment with static secrets in plaintext

        Reads the definition for the given environment with static secrets in plaintext

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._decrypt_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _decrypt_environment_serialize(
        self,
        org_name,
        project_name,
        env_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/x-yaml', 
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/decrypt',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Error:
        """Delete an environment

        Delete an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Error",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Error]:
        """Delete an environment

        Delete an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Error",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an environment

        Delete an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Error",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_environment_serialize(
        self,
        org_name,
        project_name,
        env_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/environments/{orgName}/{projectName}/{envName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_environment_revision_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete environment revision tag

        Delete environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_environment_revision_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete environment revision tag

        Delete environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_environment_revision_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete environment revision tag

        Delete environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_environment_revision_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        tag_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if tag_name is not None:
            _path_params['tagName'] = tag_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/tags/{tagName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_environment_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete environment tag

        Delete environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_environment_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete environment tag

        Delete environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_environment_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete environment tag

        Delete environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_environment_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        tag_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if tag_name is not None:
            _path_params['tagName'] = tag_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/environments/{orgName}/{projectName}/{envName}/tags/{tagName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentDefinition:
        """Read an environment

        Read an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentDefinition]:
        """Read an environment

        Read an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an environment

        Read an environment

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_environment_serialize(
        self,
        org_name,
        project_name,
        env_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/x-yaml', 
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_environment_at_version(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        version: Annotated[StrictStr, Field(description="Revision or tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentDefinition:
        """Read an environment at a specific version

        Read an environmentat a specific revision or tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param version: Revision or tag (required)
        :type version: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_at_version_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            version=version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_environment_at_version_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        version: Annotated[StrictStr, Field(description="Revision or tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentDefinition]:
        """Read an environment at a specific version

        Read an environmentat a specific revision or tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param version: Revision or tag (required)
        :type version: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_at_version_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            version=version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_environment_at_version_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        version: Annotated[StrictStr, Field(description="Revision or tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an environment at a specific version

        Read an environmentat a specific revision or tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param version: Revision or tag (required)
        :type version: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_at_version_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            version=version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDefinition",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_environment_at_version_serialize(
        self,
        org_name,
        project_name,
        env_name,
        version,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if version is not None:
            _path_params['version'] = version
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/x-yaml', 
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/{version}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_environment_e_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Return an Environment ETag

        Returns the ETag for the given environment if it exists.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_e_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "Error",
            '401': "Error",
            '404': None,
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_environment_e_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Return an Environment ETag

        Returns the ETag for the given environment if it exists.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_e_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "Error",
            '401': "Error",
            '404': None,
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_environment_e_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Return an Environment ETag

        Returns the ETag for the given environment if it exists.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_e_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "Error",
            '401': "Error",
            '404': None,
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_environment_e_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/environments/{orgName}/{projectName}/{envName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_environment_revision_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentRevisionTag:
        """Read environment revision tag

        Read environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentRevisionTag",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_environment_revision_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentRevisionTag]:
        """Read environment revision tag

        Read environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentRevisionTag",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_environment_revision_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read environment revision tag

        Read environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentRevisionTag",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_environment_revision_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        tag_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if tag_name is not None:
            _path_params['tagName'] = tag_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/tags/{tagName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_environment_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentTag:
        """Read an environment tag

        Read an environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_environment_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentTag]:
        """Read an environment tag

        Read an environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_environment_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an environment tag

        Read an environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_environment_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        tag_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if tag_name is not None:
            _path_params['tagName'] = tag_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/tags/{tagName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_environment_revision_tags(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        after: Annotated[Optional[StrictStr], Field(description="after tag for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of tags to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentRevisionTags:
        """List environment revisions

        List environment revisions

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param after: after tag for pagination
        :type after: str
        :param count: limit of tags to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_revision_tags_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            after=after,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentRevisionTags",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_environment_revision_tags_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        after: Annotated[Optional[StrictStr], Field(description="after tag for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of tags to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentRevisionTags]:
        """List environment revisions

        List environment revisions

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param after: after tag for pagination
        :type after: str
        :param count: limit of tags to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_revision_tags_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            after=after,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentRevisionTags",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_environment_revision_tags_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        after: Annotated[Optional[StrictStr], Field(description="after tag for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of tags to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List environment revisions

        List environment revisions

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param after: after tag for pagination
        :type after: str
        :param count: limit of tags to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_revision_tags_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            after=after,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentRevisionTags",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_environment_revision_tags_serialize(
        self,
        org_name,
        project_name,
        env_name,
        after,
        count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        if after is not None:
            
            _query_params.append(('after', after))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_environment_revisions(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        before: Annotated[Optional[StrictInt], Field(description="before revision number for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of revisions to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[EnvironmentRevision]:
        """List environment revisions

        List environment revisions

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param before: before revision number for pagination
        :type before: int
        :param count: limit of revisions to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_revisions_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            before=before,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[EnvironmentRevision]",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_environment_revisions_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        before: Annotated[Optional[StrictInt], Field(description="before revision number for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of revisions to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[EnvironmentRevision]]:
        """List environment revisions

        List environment revisions

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param before: before revision number for pagination
        :type before: int
        :param count: limit of revisions to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_revisions_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            before=before,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[EnvironmentRevision]",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_environment_revisions_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        before: Annotated[Optional[StrictInt], Field(description="before revision number for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of revisions to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List environment revisions

        List environment revisions

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param before: before revision number for pagination
        :type before: int
        :param count: limit of revisions to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_revisions_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            before=before,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[EnvironmentRevision]",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_environment_revisions_serialize(
        self,
        org_name,
        project_name,
        env_name,
        before,
        count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        if before is not None:
            
            _query_params.append(('before', before))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_environment_tags(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        after: Annotated[Optional[StrictStr], Field(description="after tag for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of tags to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListEnvironmentTags:
        """List environment tags

        List environment tags

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param after: after tag for pagination
        :type after: str
        :param count: limit of tags to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_tags_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            after=after,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEnvironmentTags",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_environment_tags_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        after: Annotated[Optional[StrictStr], Field(description="after tag for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of tags to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListEnvironmentTags]:
        """List environment tags

        List environment tags

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param after: after tag for pagination
        :type after: str
        :param count: limit of tags to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_tags_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            after=after,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEnvironmentTags",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_environment_tags_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        after: Annotated[Optional[StrictStr], Field(description="after tag for pagination")] = None,
        count: Annotated[Optional[StrictInt], Field(description="limit of tags to return")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List environment tags

        List environment tags

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param after: after tag for pagination
        :type after: str
        :param count: limit of tags to return
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environment_tags_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            after=after,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListEnvironmentTags",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_environment_tags_serialize(
        self,
        org_name,
        project_name,
        env_name,
        after,
        count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        if after is not None:
            
            _query_params.append(('after', after))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_environments(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        continuation_token: Annotated[Optional[StrictStr], Field(description="continuation Token from previous query to fetch next page of results")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OrgEnvironments:
        """List environments in the organization

        List environments in the organization available to the current user

        :param org_name: Organization name (required)
        :type org_name: str
        :param continuation_token: continuation Token from previous query to fetch next page of results
        :type continuation_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environments_serialize(
            org_name=org_name,
            continuation_token=continuation_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OrgEnvironments",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_environments_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        continuation_token: Annotated[Optional[StrictStr], Field(description="continuation Token from previous query to fetch next page of results")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OrgEnvironments]:
        """List environments in the organization

        List environments in the organization available to the current user

        :param org_name: Organization name (required)
        :type org_name: str
        :param continuation_token: continuation Token from previous query to fetch next page of results
        :type continuation_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environments_serialize(
            org_name=org_name,
            continuation_token=continuation_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OrgEnvironments",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_environments_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        continuation_token: Annotated[Optional[StrictStr], Field(description="continuation Token from previous query to fetch next page of results")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List environments in the organization

        List environments in the organization available to the current user

        :param org_name: Organization name (required)
        :type org_name: str
        :param continuation_token: continuation Token from previous query to fetch next page of results
        :type continuation_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_environments_serialize(
            org_name=org_name,
            continuation_token=continuation_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OrgEnvironments",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_environments_serialize(
        self,
        org_name,
        continuation_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        # process the query parameters
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def open_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        duration: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenEnvironment:
        """Open an environment session

        Opens a session the given environment for the indicated duration. This returns a session id that can be used to then read values. The default duration is 1 hour.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param duration: open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.
        :type duration: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            duration=duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OpenEnvironment",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def open_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        duration: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenEnvironment]:
        """Open an environment session

        Opens a session the given environment for the indicated duration. This returns a session id that can be used to then read values. The default duration is 1 hour.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param duration: open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.
        :type duration: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            duration=duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OpenEnvironment",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def open_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        duration: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Open an environment session

        Opens a session the given environment for the indicated duration. This returns a session id that can be used to then read values. The default duration is 1 hour.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param duration: open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.
        :type duration: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            duration=duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OpenEnvironment",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _open_environment_serialize(
        self,
        org_name,
        project_name,
        env_name,
        duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        if duration is not None:
            
            _query_params.append(('duration', duration))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}/{projectName}/{envName}/open',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def open_environment_at_version(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        version: Annotated[StrictStr, Field(description="Revision or tag")],
        duration: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OpenEnvironment:
        """Open an environment session at a specific version

        Opens a session the given environment at a specific version for the indicated duration. This returns a session id that can be used to then read values. The default duration is 1 hour.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param version: Revision or tag (required)
        :type version: str
        :param duration: open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.
        :type duration: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_environment_at_version_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            version=version,
            duration=duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OpenEnvironment",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def open_environment_at_version_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        version: Annotated[StrictStr, Field(description="Revision or tag")],
        duration: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OpenEnvironment]:
        """Open an environment session at a specific version

        Opens a session the given environment at a specific version for the indicated duration. This returns a session id that can be used to then read values. The default duration is 1 hour.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param version: Revision or tag (required)
        :type version: str
        :param duration: open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.
        :type duration: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_environment_at_version_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            version=version,
            duration=duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OpenEnvironment",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def open_environment_at_version_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        version: Annotated[StrictStr, Field(description="Revision or tag")],
        duration: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Open an environment session at a specific version

        Opens a session the given environment at a specific version for the indicated duration. This returns a session id that can be used to then read values. The default duration is 1 hour.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param version: Revision or tag (required)
        :type version: str
        :param duration: open duration - A duration string is a possibly signed sequence of decimal numbers, each with optional fraction and a unit suffix, such as “300ms”, “1.5h” or “2h45m”. Valid time units are “ns”, “us” (or “µs”), “ms”, “s”, “m”, “h”.
        :type duration: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_environment_at_version_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            version=version,
            duration=duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OpenEnvironment",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _open_environment_at_version_serialize(
        self,
        org_name,
        project_name,
        env_name,
        version,
        duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if version is not None:
            _path_params['version'] = version
        # process the query parameters
        if duration is not None:
            
            _query_params.append(('duration', duration))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/{version}/open',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read_open_environment(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        open_session_id: Annotated[StrictStr, Field(description="Open session ID returned from environment open")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Environment:
        """Read an open environment

        Reads and decrypts secrets including retrieving dynamic secrets from providers.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param open_session_id: Open session ID returned from environment open (required)
        :type open_session_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_open_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            open_session_id=open_session_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Environment",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_open_environment_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        open_session_id: Annotated[StrictStr, Field(description="Open session ID returned from environment open")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Environment]:
        """Read an open environment

        Reads and decrypts secrets including retrieving dynamic secrets from providers.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param open_session_id: Open session ID returned from environment open (required)
        :type open_session_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_open_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            open_session_id=open_session_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Environment",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_open_environment_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        open_session_id: Annotated[StrictStr, Field(description="Open session ID returned from environment open")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an open environment

        Reads and decrypts secrets including retrieving dynamic secrets from providers.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param open_session_id: Open session ID returned from environment open (required)
        :type open_session_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_open_environment_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            open_session_id=open_session_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Environment",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_open_environment_serialize(
        self,
        org_name,
        project_name,
        env_name,
        open_session_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if open_session_id is not None:
            _path_params['openSessionID'] = open_session_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/open/{openSessionID}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read_open_environment_property(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        open_session_id: Annotated[StrictStr, Field(description="Open session ID returned from environment open")],
        var_property: Annotated[StrictStr, Field(description="Path to a specific property using Pulumi path syntax https://www.pulumi.com/docs/concepts/config/#structured-configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Value:
        """Read an open environment

        Reads and decrypts secrets including retrieving dynamic secrets from providers.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param open_session_id: Open session ID returned from environment open (required)
        :type open_session_id: str
        :param var_property: Path to a specific property using Pulumi path syntax https://www.pulumi.com/docs/concepts/config/#structured-configuration (required)
        :type var_property: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_open_environment_property_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            open_session_id=open_session_id,
            var_property=var_property,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_open_environment_property_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        open_session_id: Annotated[StrictStr, Field(description="Open session ID returned from environment open")],
        var_property: Annotated[StrictStr, Field(description="Path to a specific property using Pulumi path syntax https://www.pulumi.com/docs/concepts/config/#structured-configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Value]:
        """Read an open environment

        Reads and decrypts secrets including retrieving dynamic secrets from providers.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param open_session_id: Open session ID returned from environment open (required)
        :type open_session_id: str
        :param var_property: Path to a specific property using Pulumi path syntax https://www.pulumi.com/docs/concepts/config/#structured-configuration (required)
        :type var_property: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_open_environment_property_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            open_session_id=open_session_id,
            var_property=var_property,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_open_environment_property_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        open_session_id: Annotated[StrictStr, Field(description="Open session ID returned from environment open")],
        var_property: Annotated[StrictStr, Field(description="Path to a specific property using Pulumi path syntax https://www.pulumi.com/docs/concepts/config/#structured-configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read an open environment

        Reads and decrypts secrets including retrieving dynamic secrets from providers.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param open_session_id: Open session ID returned from environment open (required)
        :type open_session_id: str
        :param var_property: Path to a specific property using Pulumi path syntax https://www.pulumi.com/docs/concepts/config/#structured-configuration (required)
        :type var_property: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_open_environment_property_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            open_session_id=open_session_id,
            var_property=var_property,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Value",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_open_environment_property_serialize(
        self,
        org_name,
        project_name,
        env_name,
        open_session_id,
        var_property,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if open_session_id is not None:
            _path_params['openSessionID'] = open_session_id
        # process the query parameters
        if var_property is not None:
            
            _query_params.append(('property', var_property))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/environments/{orgName}/{projectName}/{envName}/open//{openSessionID}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_environment_revision_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        update_environment_revision_tag: Annotated[UpdateEnvironmentRevisionTag, Field(description="Update environment revision tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update environment revision tag

        Update environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param update_environment_revision_tag: Update environment revision tag (required)
        :type update_environment_revision_tag: UpdateEnvironmentRevisionTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            update_environment_revision_tag=update_environment_revision_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_environment_revision_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        update_environment_revision_tag: Annotated[UpdateEnvironmentRevisionTag, Field(description="Update environment revision tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update environment revision tag

        Update environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param update_environment_revision_tag: Update environment revision tag (required)
        :type update_environment_revision_tag: UpdateEnvironmentRevisionTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            update_environment_revision_tag=update_environment_revision_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_environment_revision_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        update_environment_revision_tag: Annotated[UpdateEnvironmentRevisionTag, Field(description="Update environment revision tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update environment revision tag

        Update environment revision tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param update_environment_revision_tag: Update environment revision tag (required)
        :type update_environment_revision_tag: UpdateEnvironmentRevisionTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_revision_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            update_environment_revision_tag=update_environment_revision_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_environment_revision_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        tag_name,
        update_environment_revision_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if tag_name is not None:
            _path_params['tagName'] = tag_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_environment_revision_tag is not None:
            _body_params = update_environment_revision_tag


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/environments/{orgName}/{projectName}/{envName}/versions/tags/{tagName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_environment_tag(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        update_environment_tag: Annotated[UpdateEnvironmentTag, Field(description="Update environment tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentTag:
        """Update an environment tag

        Update an environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param update_environment_tag: Update environment tag (required)
        :type update_environment_tag: UpdateEnvironmentTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            update_environment_tag=update_environment_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_environment_tag_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        update_environment_tag: Annotated[UpdateEnvironmentTag, Field(description="Update environment tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentTag]:
        """Update an environment tag

        Update an environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param update_environment_tag: Update environment tag (required)
        :type update_environment_tag: UpdateEnvironmentTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            update_environment_tag=update_environment_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_environment_tag_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        tag_name: Annotated[StrictStr, Field(description="Tag name")],
        update_environment_tag: Annotated[UpdateEnvironmentTag, Field(description="Update environment tag")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an environment tag

        Update an environment tag

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param tag_name: Tag name (required)
        :type tag_name: str
        :param update_environment_tag: Update environment tag (required)
        :type update_environment_tag: UpdateEnvironmentTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_tag_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            tag_name=tag_name,
            update_environment_tag=update_environment_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentTag",
            '400': "Error",
            '401': "Error",
            '404': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_environment_tag_serialize(
        self,
        org_name,
        project_name,
        env_name,
        tag_name,
        update_environment_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        if tag_name is not None:
            _path_params['tagName'] = tag_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_environment_tag is not None:
            _body_params = update_environment_tag


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/environments/{orgName}/{projectName}/{envName}/tags/{tagName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_environment_yaml(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        body: Annotated[StrictStr, Field(description="Environment Yaml content")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EnvironmentDiagnostics:
        """Update an existing environment with Yaml file

        Validates and updates the given environment's definition.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param body: Environment Yaml content (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_yaml_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDiagnostics",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_environment_yaml_with_http_info(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        body: Annotated[StrictStr, Field(description="Environment Yaml content")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EnvironmentDiagnostics]:
        """Update an existing environment with Yaml file

        Validates and updates the given environment's definition.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param body: Environment Yaml content (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_yaml_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDiagnostics",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_environment_yaml_without_preload_content(
        self,
        org_name: Annotated[str, Field(min_length=3, strict=True, max_length=40, description="Organization name")],
        project_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Project name")],
        env_name: Annotated[str, Field(min_length=1, strict=True, max_length=100, description="Environment name")],
        body: Annotated[StrictStr, Field(description="Environment Yaml content")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an existing environment with Yaml file

        Validates and updates the given environment's definition.

        :param org_name: Organization name (required)
        :type org_name: str
        :param project_name: Project name (required)
        :type project_name: str
        :param env_name: Environment name (required)
        :type env_name: str
        :param body: Environment Yaml content (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_environment_yaml_serialize(
            org_name=org_name,
            project_name=project_name,
            env_name=env_name,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EnvironmentDiagnostics",
            '400': "EnvironmentDiagnostics",
            '401': "Error",
            '404': "Error",
            '409': "Error",
            '500': "Error",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_environment_yaml_serialize(
        self,
        org_name,
        project_name,
        env_name,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org_name is not None:
            _path_params['orgName'] = org_name
        if project_name is not None:
            _path_params['projectName'] = project_name
        if env_name is not None:
            _path_params['envName'] = env_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/x-yaml'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Authorization'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/environments/{orgName}/{projectName}/{envName}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


