from pydantic import model_validator, field_validator

from ..models import Agent, BaseOptimizationConfig


class Firework(Agent):
    pass


class FireworksOptimizationConfig(BaseOptimizationConfig):
    """
    Configuration class of the Fireworks Algorithm.
        sparks_num (int): number of sparks to be generated by each firework.\n
        a (float): (0, 1), parameter to control the explosion amplitude.\n
        b (float): (0, 1), parameter to control the explosion amplitude.\n
        explosion_amplitude (int): maximum amplitude of the explosion.\n
        gaussian_explosion_number (int): number of gaussian explosions (less than the population size).
    """
    sparks_num: int
    a: float
    b: float
    explosion_amplitude: int
    gaussian_explosion_number: int

    @model_validator(mode="after")
    def validate_gaussian_explosion_number(self) -> "FireworksOptimizationConfig":
        if self.gaussian_explosion_number > self.population_size:
            raise ValueError("\"gaussian_explosion_number\" must be less than or equal to population_size")
        return self

    @field_validator("a")
    def correct_a(cls, v):
        if not 0 < v < 1:
            raise ValueError(f"\"a\" must be a positive float lower than 1. Got {v}")
        return v

    @field_validator("b")
    def correct_b(cls, v):
        if not 0 < v < 1:
            raise ValueError(f"\"b\" must be a positive float lower than 1. Got {v}")
        return v
