# generated by datamodel-codegen:
#   filename:  api/data/createDatabase.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityReference, lifeCycle, tagLabel


class CreateDatabaseRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies this database instance uniquely.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this database.'
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the database instance. What it has and how to use it.',
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Database Service.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this database'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ...,
        description='Link to the database service fully qualified name where this database is hosted in',
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    default: Optional[bool] = Field(
        False,
        description="Some databases don't support a database/catalog in the hierarchy and use default database. For example, `MySql`. For such databases, set this flag to true to indicate that this is a default database.",
    )
    retentionPeriod: Optional[basic.Duration] = Field(
        None,
        description='Retention period of the data in the database. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`.',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of database.'
    )
    domain: Optional[str] = Field(
        None, description='Fully qualified name of the domain the Database belongs to.'
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
