# generated by datamodel-codegen:
#   filename:  api/services/createDashboardService.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.services import dashboardService
from ...type import basic, entityReference, tagLabel


class CreateDashboardServiceRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies the this entity instance uniquely'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this dashboard service.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of dashboard service entity.'
    )
    serviceType: dashboardService.DashboardServiceType
    connection: Optional[dashboardService.DashboardConnection] = None
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Dashboard Service.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this dashboard service.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    domain: Optional[str] = Field(
        None,
        description='Fully qualified name of the domain the Dashboard Service belongs to.',
    )
