# generated by datamodel-codegen:
#   filename:  api/tests/createTestDefinition.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.data import table
from ...tests import testDefinition
from ...type import basic, entityReference


class CreateTestDefinitionRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.TestCaseEntityName = Field(
        ..., description='Name that identifies this test case.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this test case.'
    )
    description: basic.Markdown = Field(..., description='Description of the testcase.')
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this TestCase definition.'
    )
    entityType: testDefinition.EntityType
    testPlatforms: List[testDefinition.TestPlatform]
    supportedDataTypes: Optional[List[table.DataType]] = None
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    parameterDefinition: Optional[
        List[testDefinition.TestCaseParameterDefinition]
    ] = None
