# generated by datamodel-codegen:
#   filename:  configuration/kafkaEventConfiguration.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'
    SSL = 'SSL'


class KafkaEventConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    topics: List[str] = Field(..., description='Topics of Kafka Producer')
    acks: Optional[str] = Field('all', description='Acknowledgment')
    retries: Optional[int] = Field(3, description='No. of retries')
    lingerMS: Optional[int] = Field(1, description='Artificial Delay in milliseconds')
    bufferMemory: Optional[int] = Field(33554432, description='Buffer Memory')
    keySerializer: Optional[str] = Field(
        'org.apache.kafka.common.serialization.StringSerializer',
        description='Serializer class for key',
    )
    valueSerializer: Optional[str] = Field(
        'org.apache.kafka.common.serialization.StringSerializer',
        description='Serializer class for value',
    )
    securityProtocol: Optional[SecurityProtocol] = Field(
        SecurityProtocol.PLAINTEXT, description='Kafka security protocol config'
    )
    SSLProtocol: Optional[str] = Field(
        'TLSv1.2', description='Kafka SSL protocol config'
    )
    SSLTrustStoreLocation: Optional[str] = Field(
        None, description='Kafka SSL truststore location'
    )
    SSLTrustStorePassword: Optional[str] = Field(
        None, description='Kafka SSL truststore password'
    )
    SSLKeystoreLocation: Optional[str] = Field(
        None, description='Kafka SSL keystore location'
    )
    SSLKeystorePassword: Optional[str] = Field(
        None, description='Kafka SSL keystore password'
    )
    SSLKeyPassword: Optional[str] = Field(None, description='Kafka SSL key password')
