# generated by datamodel-codegen:
#   filename:  entity/applications/appRunRecord.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic
from . import app


class Status(Enum):
    started = 'started'
    running = 'running'
    completed = 'completed'
    failed = 'failed'
    active = 'active'
    activeError = 'activeError'
    stopped = 'stopped'
    success = 'success'


class AppRunRecord(BaseModel):
    class Config:
        extra = Extra.forbid

    appId: Optional[basic.Uuid] = Field(
        None,
        description='Unique identifier of this application for which the job is ran.',
    )
    status: Optional[Status] = Field(None, description='Status for the Job.')
    runType: Optional[str] = Field(
        None, description='This schema defines the type of application Run.'
    )
    startTime: Optional[basic.Timestamp] = Field(
        None, description='Start of the job status.'
    )
    endTime: Optional[basic.Timestamp] = Field(
        None, description='End time of the job status.'
    )
    executionTime: Optional[basic.Timestamp] = Field(
        None, description='Execution time of the job status.'
    )
    timestamp: Optional[basic.Timestamp] = Field(
        None, description='Update time of the job status.'
    )
    failureContext: Optional[Dict[str, Any]] = Field(
        None, description='Failure Context for the Application.'
    )
    successContext: Optional[Dict[str, Any]] = Field(
        None, description='Success Context for the Application.'
    )
    scheduleInfo: Optional[app.AppSchedule] = None
