# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automatorAppConfig.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from .automator import (
    addDescriptionAction,
    addDomainAction,
    addOwnerAction,
    addTagsAction,
    addTierAction,
    lineagePropagationAction,
    mlTaggingAction,
    removeDescriptionAction,
    removeDomainAction,
    removeOwnerAction,
    removeTagsAction,
    removeTierAction,
)


class AutomatorAppType(Enum):
    Automator = 'Automator'


class Resource(BaseModel):
    type: Optional[List[str]] = Field(
        None, description="Type of the entity. E.g., 'table', 'chart',..."
    )
    queryFilter: Optional[str] = Field(
        None,
        description='Query filter to be passed to ES. E.g., `{"query":{"bool":{"must":[{"bool":{"should":[{"term":{"domain.displayName.keyword":"DG Anim"}}]}}]}}}`. This is the same payload as in the Explore page.',
    )


class Action(BaseModel):
    __root__: Union[
        addTagsAction.AddTagsAction,
        removeTagsAction.RemoveTagsAction,
        addDomainAction.AddDomainAction,
        removeDomainAction.RemoveDomainAction,
        addDescriptionAction.AddDescriptionAction,
        removeDescriptionAction.RemoveDescriptionAction,
        addTierAction.AddTierAction,
        removeTierAction.RemoveTierAction,
        addOwnerAction.AddOwnerAction,
        removeOwnerAction.RemoveOwnerAction,
        lineagePropagationAction.LineagePropagationAction,
        mlTaggingAction.MLTaggingAction,
    ] = Field(
        ...,
        description='Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.',
    )


class AutomatorAppConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    type: AutomatorAppType = Field(
        ..., description='Application Type', title='Application Type'
    )
    resources: Resource = Field(
        ..., description='Entities selected to run the automation.'
    )
    actions: List[Action] = Field(
        ...,
        description='Action to take on those entities. E.g., propagate description through lineage, auto tagging, etc.',
    )
