# generated by datamodel-codegen:
#   filename:  entity/data/container.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import storageService
from . import table


class FileFormat(Enum):
    zip = 'zip'
    gz = 'gz'
    zstd = 'zstd'
    csv = 'csv'
    tsv = 'tsv'
    json = 'json'
    parquet = 'parquet'
    avro = 'avro'


class ContainerDataModel(BaseModel):
    class Config:
        extra = Extra.forbid

    isPartitioned: Optional[bool] = Field(
        False,
        description='Whether the data under this container is partitioned by some property, eg. eventTime=yyyy-mm-dd',
    )
    columns: List[table.Column] = Field(
        ..., description="Columns belonging to this container's schema"
    )


class Container(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this container instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies the container.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description="Name that uniquely identifies a container in the format 'ServiceName.ContainerName'.",
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this container.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the container instance.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this container.'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the storage service where this container is hosted in.',
    )
    parent: Optional[entityReference.EntityReference] = Field(
        None,
        description='Link to the parent container under which this entity sits, if not top level.',
    )
    children: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='References to child containers residing under this entity.'
    )
    dataModel: Optional[ContainerDataModel] = Field(
        None,
        description="References to the container's data model, if data is structured, or null otherwise",
    )
    prefix: Optional[str] = Field(
        None, description='Optional prefix path defined for this container'
    )
    numberOfObjects: Optional[float] = Field(
        None, description='The number of objects/files this container has.'
    )
    size: Optional[float] = Field(
        None, description='The total size in KB this container has.'
    )
    fileFormats: Optional[List[FileFormat]] = Field(
        None,
        description='File & data formats identified for the container:  e.g. dataFormats=[csv, json]. These can be present both when the container has a dataModel or not',
    )
    serviceType: Optional[storageService.StorageServiceType] = Field(
        None, description='Service type this table is hosted in.'
    )
    followers: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Followers of this container.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this container.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    retentionPeriod: Optional[basic.Duration] = Field(
        None,
        description='Retention period of the data in the Container. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`.',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of container.'
    )
    fullPath: Optional[str] = Field(
        None, description='Full path of the container/file.'
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None,
        description='Domain the Container belongs to. When not set, the Container inherits the domain from the storage service it belongs to.',
    )
    dataProducts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of data products this entity is part of.'
    )
    votes: Optional[votes.Votes] = None
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle properties of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
