# generated by datamodel-codegen:
#   filename:  entity/data/searchIndex.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import searchService


class SearchIndexSettings(BaseModel):
    __root__: Optional[Dict[str, Any]] = None


class SearchIndexSampleData(BaseModel):
    class Config:
        extra = Extra.forbid

    messages: Optional[List[str]] = Field(
        None, description='List of local sample messages for a SearchIndex.'
    )


class DataType(Enum):
    NUMBER = 'NUMBER'
    TEXT = 'TEXT'
    BINARY = 'BINARY'
    TIMESTAMP = 'TIMESTAMP'
    TIMESTAMPZ = 'TIMESTAMPZ'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    KEYWORD = 'KEYWORD'
    ARRAY = 'ARRAY'
    OBJECT = 'OBJECT'
    FLATTENED = 'FLATTENED'
    NESTED = 'NESTED'
    JOIN = 'JOIN'
    RANGE = 'RANGE'
    IP = 'IP'
    VERSION = 'VERSION'
    MURMUR3 = 'MURMUR3'
    AGGREGATE_METRIC_DOUBLE = 'AGGREGATE_METRIC_DOUBLE'
    HISTOGRAM = 'HISTOGRAM'
    ANNOTATED_TEXT = 'ANNOTATED-TEXT'
    COMPLETION = 'COMPLETION'
    SEARCH_AS_YOU_TYPE = 'SEARCH_AS_YOU_TYPE'
    DENSE_VECTOR = 'DENSE_VECTOR'
    RANK_FEATURE = 'RANK_FEATURE'
    RANK_FEATURES = 'RANK_FEATURES'
    GEO_POINT = 'GEO_POINT'
    GEO_SHAPE = 'GEO_SHAPE'
    POINT = 'POINT'
    SHAPE = 'SHAPE'
    PERCOLATOR = 'PERCOLATOR'
    BOOLEAN = 'BOOLEAN'
    CONSTANT_KEYWORD = 'CONSTANT_KEYWORD'
    WILDCARD = 'WILDCARD'
    LONG = 'LONG'
    INTEGER = 'INTEGER'
    SHORT = 'SHORT'
    BYTE = 'BYTE'
    DOUBLE = 'DOUBLE'
    FLOAT = 'FLOAT'
    HALF_FLOAT = 'HALF_FLOAT'
    SCALED_FLOAT = 'SCALED_FLOAT'
    UNSIGNED_LONG = 'UNSIGNED_LONG'
    UNKNOWN = 'UNKNOWN'


class SearchIndexFieldName(BaseModel):
    __root__: constr(regex=r'^((?!::).)*$', min_length=1, max_length=256) = Field(
        ..., description='Local name (not fully qualified name) of the field. '
    )


class SearchIndexField(BaseModel):
    class Config:
        extra = Extra.forbid

    name: SearchIndexFieldName
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this searchIndexField name.'
    )
    dataType: DataType = Field(
        ..., description='Data type of the searchIndex (int, date etc.).'
    )
    dataTypeDisplay: Optional[str] = Field(
        None, description='Display name used for dataType. '
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the field.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = None
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags associated with the column.'
    )
    children: Optional[List[SearchIndexField]] = Field(
        None, description='Child columns if dataType has properties.'
    )


class SearchIndex(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this SearchIndex instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies the SearchIndex.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description="Name that uniquely identifies a SearchIndex in the format 'searchServiceName.searchIndexName'.",
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this SearchIndex. It could be title or label from the source services.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the SearchIndex instance.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the search cluster/service where this SearchIndex is hosted in.',
    )
    serviceType: Optional[searchService.SearchServiceType] = Field(
        None, description='Service type where this SearchIndex is hosted in.'
    )
    fields: List[SearchIndexField] = Field(
        ..., description='Fields in this SearchIndex.'
    )
    searchIndexSettings: Optional[SearchIndexSettings] = Field(
        None, description='Contains key/value pair of searchIndex settings.'
    )
    sampleData: Optional[SearchIndexSampleData] = Field(
        None, description='Sample data for a searchIndex.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this searchIndex.'
    )
    followers: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Followers of this searchIndex.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this searchIndex.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None,
        description='Domain the SearchIndex belongs to. When not set, the SearchIndex inherits the domain from the messaging service it belongs to.',
    )
    dataProducts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of data products this entity is part of.'
    )
    votes: Optional[votes.Votes] = None
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )


SearchIndexField.update_forward_refs()
