# generated by datamodel-codegen:
#   filename:  entity/data/storedProcedure.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import databaseService


class Language(Enum):
    SQL = 'SQL'
    Java = 'Java'
    JavaScript = 'JavaScript'
    Python = 'Python'
    External = 'External'


class StoredProcedureCode(BaseModel):
    language: Optional[Language] = Field(
        None,
        description="This schema defines the type of the language used for Stored Procedure's Code.",
    )
    code: Optional[str] = Field(
        None,
        description="This schema defines the type of the language used for Stored Procedure's Code.",
    )


class StoredProcedure(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique identifier of the StoredProcedure.')
    name: basic.EntityName = Field(..., description='Name of Stored Procedure.')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Fully qualified name of a Stored Procedure.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this Stored Procedure.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a Stored Procedure.'
    )
    storedProcedureCode: StoredProcedureCode = Field(
        ..., description='Stored Procedure Code.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the Stored Procedure.'
    )
    dataProducts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of data products this entity is part of.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the query.')
    href: Optional[basic.Href] = Field(None, description='Link to this Query resource.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    databaseSchema: Optional[entityReference.EntityReference] = Field(
        None,
        description='Reference to Database Schema that contains this stored procedure.',
    )
    database: Optional[entityReference.EntityReference] = Field(
        None, description='Reference to Database that contains this stored procedure.'
    )
    service: Optional[entityReference.EntityReference] = Field(
        None, description='Link to Database service this table is hosted in.'
    )
    serviceType: Optional[databaseService.DatabaseServiceType] = Field(
        None, description='Service type this table is hosted in.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Query.'
    )
    followers: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Followers of this Query.'
    )
    votes: Optional[votes.Votes] = None
    code: Optional[basic.SqlQuery] = Field(None, description='SQL Query definition.')
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this SQL query.'
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of database schema.'
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None,
        description='Domain the Stored Procedure belongs to. When not set, the Stored Procedure inherits the domain from the database schemna it belongs to.',
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle properties of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
