# generated by datamodel-codegen:
#   filename:  entity/feed/suggestion.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference, tagLabel


class SuggestionType(Enum):
    SuggestDescription = 'SuggestDescription'
    SuggestTagLabel = 'SuggestTagLabel'


class SuggestionStatus(Enum):
    Open = 'Open'
    Accepted = 'Accepted'
    Rejected = 'Rejected'


class Suggestion(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies an entity instance.'
    )
    type: Optional[SuggestionType] = None
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    entityLink: Optional[basic.EntityLink] = Field(
        None,
        description='Data asset about which this thread is created for with format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
    )
    createdAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    createdBy: Optional[entityReference.EntityReference] = Field(
        None, description='User or Bot who made the suggestion.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the update version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(
        None, description='User or Bot who updated the suggestion.'
    )
    status: Optional[SuggestionStatus] = SuggestionStatus.Open
    description: Optional[str] = Field(
        None, description='The main message of the thread in Markdown format.'
    )
    tagLabels: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags or Glossary Terms.'
    )
