# generated by datamodel-codegen:
#   filename:  entity/feed/thread.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReferenceList, reaction
from . import (
    assets,
    customProperty,
    description,
    domain,
    entityInfo,
    tag,
    testCaseResult,
)


class GeneratedBy(Enum):
    user = 'user'
    system = 'system'


class CardStyle(Enum):
    default = 'default'
    logicalTestCaseAdded = 'logicalTestCaseAdded'
    entityCreated = 'entityCreated'
    entityDeleted = 'entityDeleted'
    entitySoftDeleted = 'entitySoftDeleted'
    description = 'description'
    tags = 'tags'
    owner = 'owner'
    testCaseResult = 'testCaseResult'
    customProperties = 'customProperties'
    assets = 'assets'
    domain = 'domain'


class FieldOperation(Enum):
    added = 'added'
    updated = 'updated'
    deleted = 'deleted'
    none = 'none'


class TaskType(Enum):
    RequestDescription = 'RequestDescription'
    UpdateDescription = 'UpdateDescription'
    RequestTag = 'RequestTag'
    UpdateTag = 'UpdateTag'
    RequestApproval = 'RequestApproval'
    RequestTestCaseFailureResolution = 'RequestTestCaseFailureResolution'
    Generic = 'Generic'


class ThreadTaskStatus(Enum):
    Open = 'Open'
    Closed = 'Closed'


class ThreadType(Enum):
    Conversation = 'Conversation'
    Task = 'Task'
    Announcement = 'Announcement'
    Chatbot = 'Chatbot'


class AnnouncementDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    description: Optional[str] = Field(
        None,
        description='Announcement description in Markdown format. See markdown support for more details.',
    )
    startTime: basic.Timestamp = Field(
        ...,
        description='Timestamp of the start time from when the announcement should be shown.',
    )
    endTime: basic.Timestamp = Field(
        ..., description='Timestamp of when the announcement should end'
    )


class ChatbotDetails(BaseModel):
    query: Optional[str] = Field(
        None, description='The query being discussed with the Chatbot'
    )


class TaskDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    id: int = Field(..., description='Unique identifier that identifies the task.')
    type: TaskType
    assignees: entityReferenceList.EntityReferenceList = Field(
        ..., description='List of users or teams the task is assigned to'
    )
    status: Optional[ThreadTaskStatus] = ThreadTaskStatus.Open
    closedBy: Optional[str] = Field(None, description='The user that closed the task.')
    closedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Timestamp when the task was closed in Unix epoch time milliseconds.',
    )
    oldValue: Optional[str] = Field(
        None, description='The value of old object for which the task is created.'
    )
    suggestion: Optional[str] = Field(
        None,
        description='The suggestion object to replace the old value for which the task is created.',
    )
    newValue: Optional[str] = Field(
        None, description='The new value object that was accepted to complete the task.'
    )
    testCaseResolutionStatusId: Optional[basic.Uuid] = Field(
        None,
        description='The test case resolution status id for which the task is created.',
    )


class Post(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies the post.'
    )
    message: str = Field(
        ...,
        description='Message in Markdown format. See Markdown support for more details.',
    )
    postTs: Optional[basic.Timestamp] = Field(
        None, description='Timestamp of the post in Unix epoch time milliseconds.'
    )
    from_: str = Field(
        ..., alias='from', description='Name of the User posting the message.'
    )
    reactions: Optional[reaction.ReactionList] = Field(
        None, description='Reactions for the post.'
    )


class FeedInfo(BaseModel):
    class Config:
        extra = Extra.forbid

    headerMessage: Optional[str] = Field(
        None, description='Header message for the feed.'
    )
    fieldName: Optional[str] = Field(
        None, description='Field Name message for the feed.'
    )
    entitySpecificInfo: Optional[
        Union[
            assets.AssetsFeedInfo,
            customProperty.CustomPropertyFeedInfo,
            description.DescriptionFeedInfo,
            domain.DomainFeedInfo,
            entityInfo.EntityInfo,
            tag.TagFeedInfo,
            testCaseResult.TestCaseResultFeedInfo,
        ]
    ] = None


class Thread(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies an entity instance.'
    )
    type: Optional[ThreadType] = ThreadType.Conversation
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    threadTs: Optional[basic.Timestamp] = Field(
        None,
        description='Timestamp of the first post created the thread in Unix epoch time milliseconds.',
    )
    about: basic.EntityLink = Field(
        ...,
        description='Data asset about which this thread is created for with format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
    )
    entityId: Optional[basic.Uuid] = Field(
        None,
        description='Entity Id of the entity in `about` that the thread belongs to.',
    )
    entityType: Optional[str] = Field(
        None, description='Entity Type the thread is about.'
    )
    entityUrlLink: Optional[str] = Field(
        None, description='Link to the entity in `about` that the thread belongs to.'
    )
    generatedBy: Optional[GeneratedBy] = Field(
        GeneratedBy.user, description='User or team that generated the thread.'
    )
    cardStyle: Optional[CardStyle] = Field(
        CardStyle.default, description='Card style for the thread.'
    )
    fieldOperation: Optional[FieldOperation] = Field(
        FieldOperation.updated,
        description='Operation on thread, whether the field was added, or updated or deleted.',
    )
    feedInfo: Optional[FeedInfo] = Field(
        None,
        description='Entity Id of the entity in `about` that the thread belongs to.',
    )
    addressedTo: Optional[basic.EntityLink] = Field(
        None,
        description='User or team this thread is addressed to in format <#E::{entities}::{entityName}::{field}::{fieldValue}.',
    )
    createdBy: Optional[str] = Field(None, description='User who created the thread.')
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    resolved: Optional[bool] = Field(
        False, description='When `true` indicates the thread has been resolved.'
    )
    message: str = Field(
        ..., description='The main message of the thread in Markdown format.'
    )
    postsCount: Optional[int] = Field(
        0, description='The total count of posts in the thread.'
    )
    posts: Optional[List[Post]] = None
    reactions: Optional[reaction.ReactionList] = Field(
        None, description='Reactions for the thread.'
    )
    task: Optional[TaskDetails] = Field(
        None,
        description='Details about the task. This is only applicable if thread is of type task.',
    )
    announcement: Optional[AnnouncementDetails] = Field(
        None,
        description='Details about the announcement. This is only applicable if thread is of type announcement.',
    )
    chatbot: Optional[ChatbotDetails] = Field(
        None,
        description='Details about the Chatbot conversation. This is only applicable if thread is of type Chatbot.',
    )
