# generated by datamodel-codegen:
#   filename:  entity/services/connections/connectionBasicType.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import Any, Dict, Optional, Union

from pydantic import BaseModel, Extra, Field

from ....security.credentials import awsCredentials


class ConnectionType(BaseModel):
    __root__: Any = Field(
        ...,
        description='This schema defines basic common types that are used by other schemas.',
        title='ConnectionType',
    )


class ConnectionOptions(BaseModel):
    __root__: Optional[Dict[str, str]] = None


class ConnectionArguments(BaseModel):
    __root__: Optional[Dict[str, Any]] = None


class SupportsMetadataExtraction(BaseModel):
    __root__: bool = Field(..., description='Supports Metadata Extraction.')


class SupportsUsageExtraction(BaseModel):
    __root__: bool = Field(..., description='Supports Usage Extraction.')


class SupportsLineageExtraction(BaseModel):
    __root__: bool = Field(..., description='Supports Lineage Extraction.')


class SupportsProfiler(BaseModel):
    __root__: bool = Field(..., description='Supports Profiler')


class SupportsDatabase(BaseModel):
    __root__: bool = Field(
        ...,
        description='The source service supports the database concept in its hierarchy',
    )


class SupportsQueryComment(BaseModel):
    __root__: bool = Field(
        ...,
        description='For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.',
    )


class SupportsDataInsightExtraction(BaseModel):
    __root__: bool = Field(..., description='Support Metadata To Elastic Search')


class SupportsElasticSearchReindexingExtraction(BaseModel):
    __root__: bool = Field(..., description='Support Elastic Search Reindexing')


class SupportsDBTExtraction(BaseModel):
    __root__: bool = Field(..., description='Supports DBT Extraction.')


class DataStorageConfig(BaseModel):
    bucketName: Optional[str] = Field(
        '', description='Bucket Name', title='Bucket Name'
    )
    prefix: Optional[str] = Field(
        '', description='Prefix of the data source.', title='Prefix'
    )
    filePathPattern: Optional[str] = Field(
        '{service_name}/{database_name}/{database_schema_name}/{table_name}/sample_data.parquet',
        description='Provide the pattern of the path where the generated sample data file needs to be stored.',
        title='File Path Pattern',
    )
    overwriteData: Optional[bool] = Field(
        True,
        description='When this field enabled a single parquet file will be created to store sample data, otherwise we will create a new file per day',
        title='Overwrite Sample Data',
    )
    storageConfig: Optional[Union[awsCredentials.AWSCredentials, Dict[str, Any]]] = None


class SampleDataStorageConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[Union[DataStorageConfig, Dict[str, Any]]] = None
