# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/mstrConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class MstrType(Enum):
    Mstr = 'Mstr'


class MstrConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MstrType] = Field(
        MstrType.Mstr, description='Service Type', title='Service Type'
    )
    username: str = Field(
        ...,
        description='Username to connect to MSTR. This user should have privileges to read all the metadata in MSTR.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to MSTR.', title='Password'
    )
    hostPort: AnyUrl = Field(
        ...,
        description='Host and Port of the Metabase instance.',
        title='Host and Port',
    )
    projectName: Optional[str] = Field(
        None, description='MSTR Project Name', title='Project Name'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
