# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/qlikSenseConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class QlikSenseType(Enum):
    QlikSense = 'QlikSense'


class QlikCertificatePath(BaseModel):
    clientCertificate: str = Field(
        ..., description='Client Certificate', title='Client Certificate Path'
    )
    clientKeyCertificate: str = Field(
        ..., description='Client Key Certificate.', title='Client Key Certificate'
    )
    rootCertificate: str = Field(
        ..., description='Root Certificate.', title='Root Certificate'
    )


class QlikCertificateValues(BaseModel):
    sslConfig: verifySSLConfig.SslConfig


class QlikSenseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[QlikSenseType] = Field(
        QlikSenseType.QlikSense, description='Service Type', title='Service Type'
    )
    displayUrl: Optional[AnyUrl] = Field(
        None,
        description='Qlik Sense Base URL, used for genrating dashboard & chat url',
        title='Qlik Sense Base URL',
    )
    hostPort: AnyUrl = Field(
        ...,
        description='URL for the Qlik instance.',
        title='Qlik Engine JSON API Websocket URL',
    )
    certificates: Union[QlikCertificateValues, QlikCertificatePath]
    validateHostName: Optional[bool] = Field(
        False, description='Validate Host Name', title='Validate Host Name'
    )
    userDirectory: Optional[str] = Field(
        None, description='User Directory.', title='User Directory'
    )
    userId: Optional[str] = Field(None, description='User ID.', title='User ID')
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
