# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/dorisConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class DorisType(Enum):
    Doris = 'Doris'


class DorisScheme(Enum):
    doris = 'doris'


class DorisConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DorisType] = Field(
        DorisType.Doris, description='Service Type', title='Service Type'
    )
    scheme: Optional[DorisScheme] = Field(
        DorisScheme.doris,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Doris. This user should have privileges to read all the metadata in Doris.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to Doris.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Doris service.', title='Host and Port'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
        title='Database Schema',
    )
    sslConfig: Optional[verifySSLConfig.SslConfig] = Field(
        None, description='SSL Configuration details.', title='SSL'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
