# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/iceberg/restCatalogConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from ...common import sslCertPaths
from . import icebergFileSystem


class Credential(BaseModel):
    class Config:
        extra = Extra.forbid

    clientId: CustomSecretStr = Field(
        ..., description='OAuth2 Client ID.', title='Client ID'
    )
    clientSecret: CustomSecretStr = Field(
        ..., description='OAuth2 Client Secret', title='Client Secret'
    )


class Sigv4(BaseModel):
    signingRegion: Optional[str] = Field(
        None,
        description='AWS Region to use when SigV4 signs a request.',
        title='Signing AWS Region',
    )
    signingName: Optional[str] = Field(
        None,
        description='The service signing name to use when SigV4 signs a request.',
        title='Signing Name',
    )


class RestCatalogConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    uri: AnyUrl = Field(
        ...,
        description="Uri to the REST catalog. Example: 'http://rest-catalog/ws/'",
        title='URI',
    )
    credential: Optional[Credential] = Field(
        None,
        description='OAuth2 credential to use when initializing the catalog.',
        title='OAuth2 Credential',
    )
    token: Optional[CustomSecretStr] = Field(
        None,
        description="Berarer token to use for the 'Authorization' header.",
        title='Token',
    )
    ssl: Optional[sslCertPaths.SslCertificatesByPath] = Field(
        None, description='SSL Configuration details.', title='SSL'
    )
    sigv4: Optional[Sigv4] = Field(
        None,
        description='Sign requests to the REST Server using AWS SigV4 protocol.',
        title='Sigv4',
    )
    fileSystem: Optional[icebergFileSystem.IcebergFileSystem] = None
