# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/mongoDBConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class MongoDBType(Enum):
    MongoDB = 'MongoDB'


class MongoDBScheme(Enum):
    mongodb = 'mongodb'
    mongodb_srv = 'mongodb+srv'


class MongoDBConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MongoDBType] = Field(
        MongoDBType.MongoDB, description='Service Type', title='Service Type'
    )
    scheme: Optional[MongoDBScheme] = Field(
        MongoDBScheme.mongodb,
        description='Mongo connection scheme options.',
        title='Connection Scheme',
    )
    username: Optional[str] = Field(
        None,
        description='Username to connect to MongoDB. This user should have privileges to read all the metadata in MongoDB.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to MongoDB.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the MongoDB service.', title='Host and Port'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
