# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/sapHana/sapHanaSQLConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr


class SapHanaSQLConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    hostPort: str = Field(
        ..., description='Host and port of the Hana service.', title='Host and Port'
    )
    username: str = Field(
        ...,
        description='Username to connect to Hana. This user should have privileges to read all the metadata.',
        title='Username',
    )
    password: CustomSecretStr = Field(
        ..., description='Password to connect to Hana.', title='Password'
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='Database Schema of the data source. This is an optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
        title='Database Schema',
    )
    database: Optional[str] = Field(
        None, description='Database of the data source.', title='Database'
    )
