# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/sapHanaConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType
from .sapHana import sapHanaHDBConnection, sapHanaSQLConnection


class SapHanaType(Enum):
    SapHana = 'SapHana'


class SapHanaScheme(Enum):
    hana = 'hana'


class SapHanaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SapHanaType] = Field(
        SapHanaType.SapHana, description='Service Type', title='Service Type'
    )
    scheme: Optional[SapHanaScheme] = Field(
        SapHanaScheme.hana,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    connection: Union[
        sapHanaSQLConnection.SapHanaSQLConnection,
        sapHanaHDBConnection.SapHanaHDBConnection,
    ] = Field(
        ...,
        description='Choose between Database connection or HDB User Store connection.',
        title='SAP Hana Connection',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='Storage Config for Sample Data')
