# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/teradataConnection.json
#   timestamp: 2024-07-04T09:01:46+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class Logmech(Enum):
    TD2 = 'TD2'
    JWT = 'JWT'
    KRB5 = 'KRB5'
    CUSTOM = 'CUSTOM'
    TDNEGO = 'TDNEGO'


class Tmode(Enum):
    ANSI = 'ANSI'
    TERA = 'TERA'
    DEFAULT = 'DEFAULT'


class TeradataType(Enum):
    Teradata = 'Teradata'


class TeradataScheme(Enum):
    teradatasql = 'teradatasql'


class TeradataConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TeradataType] = Field(
        TeradataType.Teradata, description='Service Type', title='Service Type'
    )
    scheme: Optional[TeradataScheme] = Field(
        TeradataScheme.teradatasql,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Teradata. This user should have privileges to read all the metadata in Teradata.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to Teradata.', title='Password'
    )
    logmech: Optional[Logmech] = Field(
        Logmech.TD2,
        description='Specifies the logon authentication method. Possible values are TD2 (the default), JWT, LDAP, KRB5 for Kerberos, or TDNEGO',
        title='LOGMECH',
    )
    logdata: Optional[str] = Field(
        None,
        description='Specifies additional data needed by a logon mechanism, such as a secure token, Distinguished Name, or a domain/realm name. LOGDATA values are specific to each logon mechanism.',
        title='Extra data for the chosen logon authentication method (LOGDATA)',
    )
    hostPort: str = Field(
        ..., description='Host and port of the Teradata service.', title='Host and Port'
    )
    tmode: Optional[Tmode] = Field(
        Tmode.DEFAULT,
        description='Specifies the transaction mode for the connection',
        title='Transaction mode',
    )
    account: Optional[str] = Field(
        None,
        description='Specifies an account string to override the default account string defined for the database user. Accounts are used by the database for workload management and resource usage monitoring.',
        title='Teradata Database account',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='Storage Config for Sample Data')
